/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.io;

import com.dell.doradus.common.Utils;
import com.dell.doradus.olap.io.BufferReaderRow;
import com.dell.doradus.olap.io.BufferWriterRow;
import com.dell.doradus.olap.io.CassandraIO;
import com.dell.doradus.olap.io.ColumnValue;
import com.dell.doradus.olap.io.DataCache;
import com.dell.doradus.olap.io.FileDeletedException;
import com.dell.doradus.olap.io.FileInfo;
import com.dell.doradus.olap.io.StorageHelper;
import com.dell.doradus.olap.io.VInputStream;
import com.dell.doradus.olap.io.VOutputStream;
import com.dell.doradus.service.db.Tenant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VDirectory {
    private static Logger m_logger = LoggerFactory.getLogger((String)"Olap.VDirectory");
    static int CHUNK_SIZE = 0x100000;
    private VDirectory m_parent;
    private StorageHelper m_helper;
    private String m_storeName;
    private String m_name;
    private String m_row;
    private DataCache m_dataCache;
    private Map<String, FileInfo> m_filesMap;
    private Object m_syncRoot = new Object();

    public VDirectory(Tenant tenant, String storeName) {
        this.m_parent = null;
        CassandraIO io = new CassandraIO(tenant);
        this.m_helper = new StorageHelper(io);
        this.m_storeName = storeName;
        this.m_name = "$root";
        this.m_helper.createCF(this.m_storeName);
        this.m_row = "Directory/" + this.m_name;
        this.m_dataCache = new DataCache(this.m_storeName, this.m_row, this.m_helper);
    }

    private VDirectory(VDirectory parent, String name) {
        this.m_parent = parent;
        this.m_helper = parent.m_helper;
        this.m_storeName = parent.m_storeName;
        this.m_name = name;
        this.m_row = String.valueOf(this.m_parent.m_row) + "/" + this.m_name;
        this.m_dataCache = new DataCache(this.m_storeName, this.m_row, this.m_helper);
    }

    public VDirectory getParent() {
        return this.m_parent;
    }

    public String getName() {
        return this.m_name;
    }

    public String getStoreName() {
        return this.m_storeName;
    }

    public String getRow() {
        return this.m_row;
    }

    public VDirectory getDirectoryCreate(String name) {
        VDirectory child = new VDirectory(this, name);
        child.create();
        return child;
    }

    public VDirectory getDirectory(String name) {
        return new VDirectory(this, name);
    }

    public List<String> listDirectories() {
        List<ColumnValue> list = this.m_helper.get(this.m_storeName, this.m_row, "Directory/");
        ArrayList<String> result = new ArrayList<String>(list.size());
        for (ColumnValue v : list) {
            result.add(v.columnName);
        }
        return result;
    }

    public boolean directoryExists(String name) {
        byte[] b = this.m_helper.getValue(this.m_storeName, this.m_row, "Directory/" + name);
        return b != null;
    }

    public boolean fileExists(String file) {
        return this.getFileInfo(file) != null;
    }

    public long totalLength(boolean recursive) {
        long totalLength = 0L;
        for (FileInfo f : this.listFiles()) {
            totalLength += f.getLength();
        }
        if (recursive) {
            for (String child : this.listDirectories()) {
                totalLength += this.getDirectory(child).totalLength(recursive);
            }
        }
        return totalLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create() {
        Object object = this.m_syncRoot;
        synchronized (object) {
            if (this.m_parent == null) {
                return;
            }
            this.m_dataCache.flush();
            this.m_helper.write(this.m_storeName, this.m_parent.m_row, "Directory/" + this.m_name, new byte[0]);
            this.m_filesMap = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Object object = this.m_syncRoot;
        synchronized (object) {
            if (this.m_parent == null) {
                return;
            }
            this.m_dataCache.flush();
            this.m_filesMap = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() {
        if (this.m_parent == null) {
            this.m_helper.deleteCF(this.m_storeName);
            m_logger.info("Deleted CF {}", (Object)this.m_storeName);
        } else {
            Collection<FileInfo> childFiles = this.listFiles();
            this.m_helper.delete(this.m_storeName, this.m_parent.m_row, "Directory/" + this.m_name);
            boolean hasSharesRow = false;
            for (FileInfo child : childFiles) {
                if (child.getSingleRow()) continue;
                if (child.getSharesRow()) {
                    hasSharesRow = true;
                    continue;
                }
                this.m_helper.delete(this.m_storeName, String.valueOf(this.m_row) + "/" + child.getName());
            }
            if (hasSharesRow) {
                this.m_helper.delete(this.m_storeName, String.valueOf(this.m_row) + "/_share");
            }
            List<String> childDirs = this.listDirectories();
            for (String child : childDirs) {
                this.getDirectory(child).delete();
            }
            this.m_helper.delete(this.m_storeName, this.m_row);
            m_logger.debug("Deleted {}", (Object)this.m_row);
            Object object = this.m_syncRoot;
            synchronized (object) {
                this.m_filesMap.clear();
            }
        }
    }

    private void loadFiles() {
        this.m_filesMap = new HashMap<String, FileInfo>();
        List<ColumnValue> list = this.m_helper.get(this.m_storeName, this.m_row, "File/");
        for (ColumnValue v : list) {
            FileInfo fi = new FileInfo(v.columnName, v.getString());
            this.m_filesMap.put(fi.getName(), fi);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<FileInfo> listFiles() {
        Object object = this.m_syncRoot;
        synchronized (object) {
            if (this.m_filesMap == null) {
                this.loadFiles();
            }
            return this.m_filesMap.values();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileInfo getFileInfo(String file) {
        Object object = this.m_syncRoot;
        synchronized (object) {
            if (this.m_filesMap == null) {
                this.loadFiles();
            }
            return this.m_filesMap.get(file);
        }
    }

    public long fileLength(String file) {
        FileInfo info = this.getFileInfo(file);
        if (info == null) {
            return -1L;
        }
        return info.getLength();
    }

    public long compressedLength(FileInfo file) {
        long compressedLength = file.getCompressedLength();
        if (compressedLength > 0L) {
            return compressedLength;
        }
        if (file.getUncompressed()) {
            return file.getLength();
        }
        if (file.getLength() == 0L) {
            return 0L;
        }
        compressedLength = 0L;
        int i = 0;
        byte[] val = null;
        while ((val = file.getSingleRow() ? this.m_helper.getValue(this.m_storeName, this.m_row, "Data/" + file.getName() + "/" + i) : (file.getSharesRow() ? this.m_helper.getValue(this.m_storeName, String.valueOf(this.m_row) + "/_share", String.valueOf(file.getName()) + "/" + i) : this.m_helper.getValue(this.m_storeName, String.valueOf(this.m_row) + "/" + file.getName(), "" + i))) != null) {
            compressedLength += (long)val.length;
            ++i;
        }
        return compressedLength;
    }

    public VInputStream open(String name) {
        FileInfo info = this.getFileInfo(name);
        if (info == null) {
            throw new FileDeletedException("File '" + name + "' does not exist in '" + this.m_storeName + "/" + this.m_row + "'");
        }
        BufferReaderRow bufferReader = new BufferReaderRow(this.m_helper, this.m_storeName, this.m_row, info);
        VInputStream stream = new VInputStream(bufferReader, info.getLength());
        return stream;
    }

    public VOutputStream create(String name) {
        BufferWriterRow bufferWriter = new BufferWriterRow(this.m_dataCache, this.m_helper, this.m_storeName, this.m_row, name);
        VOutputStream stream = new VOutputStream(bufferWriter);
        return stream;
    }

    public String getProperty(String name) {
        byte[] buffer = this.m_helper.getValue(this.m_storeName, this.m_row, "Property/" + name);
        if (buffer == null) {
            FileInfo info = this.getFileInfo(name);
            if (info == null) {
                return null;
            }
            VInputStream stream = this.open(name);
            buffer = new byte[(int)stream.length()];
            stream.read(buffer, 0, buffer.length);
        }
        return Utils.toString((byte[])buffer);
    }

    public void putProperty(String name, String value) {
        if (value == null) {
            this.m_helper.delete(this.m_storeName, this.m_row, "Property/" + name);
        } else {
            this.m_helper.write(this.m_storeName, this.m_row, "Property/" + name, Utils.toBytes((String)value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFile(String name) {
        FileInfo fi = this.getFileInfo(name);
        if (fi == null) {
            return;
        }
        if (fi.getSingleRow()) {
            this.m_helper.delete(this.m_storeName, this.m_row, "Data/" + name + "/0");
        } else if (fi.getSharesRow()) {
            this.m_helper.delete(this.m_storeName, String.valueOf(this.m_row) + "/_share", String.valueOf(name) + "/0");
        } else {
            this.m_helper.delete(this.m_storeName, String.valueOf(this.m_row) + "/" + name);
        }
        this.m_helper.delete(this.m_storeName, this.m_row, "File/" + name);
        Object object = this.m_syncRoot;
        synchronized (object) {
            if (this.m_filesMap != null) {
                this.m_filesMap.remove(name);
            }
        }
    }
}

