/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.io;

import com.dell.doradus.common.Utils;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;

public final class Utf8Encoder {
    private final CharsetEncoder utf8_encoder = Utils.UTF8_CHARSET.newEncoder();
    private final CharsetDecoder utf8_decoder = Utils.UTF8_CHARSET.newDecoder();
    private char[] charArray = new char[16384];

    public int encode(String value, byte[] buffer) {
        this.utf8_encoder.reset();
        if (this.charArray.length < value.length()) {
            this.charArray = new char[value.length() * 2];
        }
        ByteBuffer bb = ByteBuffer.wrap(buffer);
        value.getChars(0, value.length(), this.charArray, 0);
        CharBuffer cb = CharBuffer.wrap(this.charArray, 0, value.length());
        this.utf8_encoder.encode(cb, bb, true);
        this.utf8_encoder.flush(bb);
        int length = bb.position();
        return length;
    }

    public String decode(byte[] buffer, int length) {
        this.utf8_decoder.reset();
        ByteBuffer bb = ByteBuffer.wrap(buffer, 0, length);
        if (this.charArray.length < length) {
            this.charArray = new char[length * 2];
        }
        CharBuffer cb = CharBuffer.wrap(this.charArray);
        this.utf8_decoder.decode(bb, cb, true);
        this.utf8_decoder.flush(cb);
        return new String(this.charArray, 0, cb.position());
    }
}

