/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.io;

import com.dell.doradus.olap.io.ColumnValue;
import com.dell.doradus.olap.io.FileCache;
import com.dell.doradus.olap.io.FileDeletedException;
import com.dell.doradus.olap.io.IO;
import java.util.ArrayList;
import java.util.List;

public class StorageHelper {
    private FileCache m_fileCache;
    private IO m_io;

    public StorageHelper(IO io) {
        this.m_io = io;
        this.m_fileCache = new FileCache();
    }

    public void writeFileChunk(String app, String key, String columnName, byte[] value) {
        this.write(app, key, columnName, value);
        this.m_fileCache.put(app, key, columnName, value);
    }

    public void writeFileChunks(String app, String key, List<ColumnValue> columns) {
        this.write(app, key, columns);
        for (ColumnValue cv : columns) {
            this.m_fileCache.put(app, key, cv.columnName, cv.columnValue);
        }
    }

    public byte[] readFileChunk(String app, String key, String columnName) {
        byte[] value = this.m_fileCache.get(app, key, columnName);
        if (value == null) {
            value = this.getValue(app, key, columnName);
            if (value == null) {
                throw new FileDeletedException();
            }
            this.m_fileCache.put(app, key, columnName, value);
        }
        return value;
    }

    public void write(String app, String key, String columnName, byte[] value) {
        ColumnValue v = new ColumnValue(columnName);
        v.columnValue = value;
        ArrayList<ColumnValue> list = new ArrayList<ColumnValue>(1);
        list.add(v);
        this.write(app, key, list);
    }

    public void createCF(String name) {
        this.m_io.createCF(name);
    }

    public void deleteCF(String name) {
        this.m_io.deleteCF(name);
    }

    public void delete(String app, String key) {
        this.delete(app, key, null);
    }

    public byte[] getValue(String app, String key, String column) {
        return this.m_io.getValue(app, key, column);
    }

    public List<ColumnValue> get(String app, String key, String prefix) {
        return this.m_io.get(app, key, prefix);
    }

    protected void write(String app, String key, List<ColumnValue> values) {
        this.m_io.write(app, key, values);
    }

    protected void delete(String columnFamily, String key, String columnName) {
        this.m_io.delete(columnFamily, key, columnName);
    }
}

