/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.io;

import com.dell.doradus.olap.io.ColumnValue;
import com.dell.doradus.olap.io.IO;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MSSqlIO
implements IO {
    private static Logger LOG = LoggerFactory.getLogger(MSSqlIO.class);
    private Connection m_connection;

    public MSSqlIO() {
        try {
            String url = "jdbc:sqlserver://localhost\\SQLEXPRESS;databaseName=DoradusDB";
            Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
            this.m_connection = DriverManager.getConnection(url, "sa", "admin");
        }
        catch (Exception e) {
            LOG.error("Error initializing SQL", (Throwable)e);
            throw new RuntimeException("Error initializing SQL", e);
        }
    }

    @Override
    public byte[] getValue(String app, String key, String column) {
        try {
            PreparedStatement stmt = this.m_connection.prepareStatement("SELECT data FROM OLAP WHERE keyid=? AND colid=?");
            String keyid = String.valueOf(app) + "/" + key;
            String colid = column;
            stmt.setString(1, keyid);
            stmt.setString(2, colid);
            ResultSet rs = stmt.executeQuery();
            byte[] data = null;
            if (rs.next()) {
                data = rs.getBytes(1);
            }
            rs.close();
            stmt.close();
            return data;
        }
        catch (SQLException e) {
            LOG.error("Sql", (Throwable)e);
            throw new RuntimeException("sql", e);
        }
    }

    @Override
    public List<ColumnValue> get(String app, String key, String prefix) {
        try {
            PreparedStatement stmt = this.m_connection.prepareStatement("SELECT colid, data FROM OLAP WHERE keyid=? and colid >= ?");
            ArrayList<ColumnValue> result = new ArrayList<ColumnValue>();
            String keyid = String.valueOf(app) + "/" + key;
            stmt.setString(1, keyid);
            stmt.setString(2, prefix);
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                String colid = rs.getString(1);
                if (!colid.startsWith(prefix)) break;
                byte[] data = rs.getBytes(2);
                result.add(new ColumnValue(colid.substring(prefix.length()), data));
            }
            rs.close();
            stmt.close();
            return result;
        }
        catch (SQLException e) {
            LOG.error("Sql", (Throwable)e);
            throw new RuntimeException("sql", e);
        }
    }

    @Override
    public void createCF(String name) {
    }

    @Override
    public void deleteCF(String name) {
        try {
            PreparedStatement stmt = this.m_connection.prepareStatement("DELETE FROM OLAP WHERE keyid LIKE ?");
            stmt.setString(1, String.valueOf(name) + "%");
            stmt.execute();
            stmt.close();
        }
        catch (SQLException e) {
            LOG.error("Sql", (Throwable)e);
            throw new RuntimeException("sql", e);
        }
    }

    @Override
    public void write(String app, String key, List<ColumnValue> values) {
        try {
            PreparedStatement stmt = this.m_connection.prepareStatement("if exists (SELECT 1 FROM OLAP WHERE keyid=? and colid=?) UPDATE OLAP SET data=? WHERE keyid=? and colid=? ELSE INSERT INTO OLAP VALUES(?,?,?)");
            String keyid = String.valueOf(app) + "/" + key;
            for (ColumnValue v : values) {
                stmt.setString(1, keyid);
                stmt.setString(2, v.columnName);
                stmt.setBytes(3, v.columnValue);
                stmt.setString(4, keyid);
                stmt.setString(5, v.columnName);
                stmt.setString(6, keyid);
                stmt.setString(7, v.columnName);
                stmt.setBytes(8, v.columnValue);
                stmt.executeUpdate();
            }
            stmt.close();
        }
        catch (SQLException e) {
            LOG.error("Sql", (Throwable)e);
            throw new RuntimeException("sql", e);
        }
    }

    @Override
    public void delete(String columnFamily, String sKey, String columnName) {
        String keyid = String.valueOf(columnFamily) + "/" + sKey;
        if (columnName == null) {
            try {
                PreparedStatement stmt = this.m_connection.prepareStatement("DELETE FROM OLAP WHERE keyid=?");
                stmt.setString(1, keyid);
                stmt.execute();
                stmt.close();
            }
            catch (SQLException e) {
                LOG.error("Sql", (Throwable)e);
                throw new RuntimeException("sql", e);
            }
        }
        try {
            PreparedStatement stmt = this.m_connection.prepareStatement("DELETE FROM OLAP WHERE keyid=? AND colid=?");
            stmt.setString(1, keyid);
            stmt.setString(2, columnName);
            stmt.execute();
            stmt.close();
        }
        catch (SQLException e) {
            LOG.error("Sql", (Throwable)e);
            throw new RuntimeException("sql", e);
        }
    }
}

