/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.io;

import com.dell.doradus.olap.io.Compressor;
import com.dell.doradus.olap.io.IBufferWriter;
import java.util.ArrayList;
import java.util.List;

public class InMemoryBufferWriter
implements IBufferWriter {
    private List<byte[]> m_buffers = new ArrayList<byte[]>();
    private long m_length;

    @Override
    public void writeBuffer(int bufferNumber, byte[] buffer, int length) {
        if (bufferNumber != this.m_buffers.size()) {
            throw new RuntimeException("Error!");
        }
        byte[] buf = new byte[length];
        System.arraycopy(buffer, 0, buf, 0, length);
        buf = Compressor.compress(buf);
        this.m_buffers.add(buf);
    }

    @Override
    public void close(long length) {
        this.m_length = length;
    }

    public List<byte[]> getData() {
        return this.m_buffers;
    }

    public long getLength() {
        return this.m_length;
    }

    public long getCompressedLength() {
        long length = 0L;
        for (byte[] buffer : this.m_buffers) {
            length += (long)buffer.length;
        }
        return length;
    }
}

