/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.io;

public class FileInfo
implements Comparable<FileInfo> {
    private String m_name;
    private boolean m_uncompressed;
    private boolean m_sharesRow;
    private long m_length;
    private boolean m_singleRow;
    private long m_compressedLength;

    public FileInfo(String name) {
        this.m_name = name;
    }

    public FileInfo(String name, String info) {
        this.m_name = name;
        if (info.charAt(0) == 'u') {
            info = info.substring(1);
            this.m_uncompressed = true;
        }
        if (info.charAt(0) == 's') {
            info = info.substring(1);
            this.m_sharesRow = true;
        }
        if (info.charAt(0) == 'r') {
            info = info.substring(1);
            this.m_singleRow = true;
        }
        if (info.charAt(0) == 'c') {
            info = info.substring(1);
            int idx = info.indexOf(99);
            String val = info.substring(0, idx);
            this.m_compressedLength = Long.parseLong(val);
            this.m_singleRow = true;
            info = info.substring(idx + 1);
        }
        this.m_length = Long.parseLong(info);
    }

    public String getName() {
        return this.m_name;
    }

    public long getLength() {
        return this.m_length;
    }

    public boolean getUncompressed() {
        return this.m_uncompressed;
    }

    public boolean isCompressed() {
        return !this.m_uncompressed;
    }

    public boolean getSharesRow() {
        return this.m_sharesRow;
    }

    public boolean getSingleRow() {
        return this.m_singleRow;
    }

    public long getCompressedLength() {
        return this.m_compressedLength;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setLength(long length) {
        this.m_length = length;
    }

    public void setUncompressed(boolean uncompressed) {
        this.m_uncompressed = uncompressed;
    }

    public void setSharesRow(boolean sharesRow) {
        this.m_sharesRow = sharesRow;
    }

    public void setSingleRow(boolean singleRow) {
        this.m_singleRow = singleRow;
    }

    public void setCompressedLength(long compressedLength) {
        this.m_compressedLength = compressedLength;
    }

    public String asString() {
        StringBuilder sb = new StringBuilder(16);
        if (this.m_uncompressed) {
            sb.append('u');
        }
        if (this.m_sharesRow) {
            sb.append('s');
        }
        if (this.m_singleRow) {
            sb.append('r');
        }
        if (this.m_compressedLength > 0L) {
            sb.append('c');
            sb.append(this.m_compressedLength);
            sb.append('c');
        }
        sb.append(this.m_length);
        String result = sb.toString();
        return result;
    }

    @Override
    public int compareTo(FileInfo other) {
        return this.m_name.compareTo(other.m_name);
    }
}

