/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.io;

import com.dell.doradus.common.Utils;
import com.dell.doradus.olap.io.ColumnValue;
import com.dell.doradus.olap.io.IO;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileIO
implements IO {
    private static Logger LOG = LoggerFactory.getLogger(FileIO.class);
    private File main = new File("C:/DoradusDB");

    public FileIO() {
        if (!this.main.exists()) {
            this.main.mkdir();
        }
    }

    @Override
    public byte[] getValue(String app, String key, String column) {
        File file = new File(this.main.getAbsoluteFile() + "/" + app + "/" + key + "/" + column.replace('/', '@'));
        if (!file.exists()) {
            return null;
        }
        try {
            FileInputStream fis = new FileInputStream(file);
            byte[] b = new byte[(int)file.length()];
            fis.read(b, 0, b.length);
            fis.close();
            return b;
        }
        catch (IOException e) {
            LOG.error("Error reading file", (Throwable)e);
            throw new RuntimeException("Error reading file", e);
        }
    }

    @Override
    public List<ColumnValue> get(String app, String key, String prefix) {
        File[] files;
        prefix = prefix.replace('/', '@');
        File dir = new File(this.main.getAbsoluteFile() + "/" + app + "/" + key);
        ArrayList<ColumnValue> result = new ArrayList<ColumnValue>();
        if (!dir.exists()) {
            return result;
        }
        File[] fileArray = files = dir.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String column = file.getName();
            if (column.startsWith(prefix)) {
                byte[] value = this.getValue(app, key, column);
                result.add(new ColumnValue(column.substring(prefix.length()).replace('@', '/'), value));
            }
            ++n2;
        }
        return result;
    }

    @Override
    public void createCF(String name) {
        File dir = new File(this.main.getAbsoluteFile() + "/" + name);
        if (!dir.exists()) {
            dir.mkdir();
        }
    }

    @Override
    public void deleteCF(String name) {
        File dir = new File(this.main.getAbsoluteFile() + "/" + name);
        if (dir.exists()) {
            Utils.deleteDirectory((File)dir);
        }
    }

    @Override
    public void write(String app, String key, List<ColumnValue> values) {
        File dir = new File(this.main.getAbsoluteFile() + "/" + app + "/" + key);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        for (ColumnValue v : values) {
            File file = new File(dir, v.columnName.replace('/', '@'));
            try {
                FileOutputStream fos = new FileOutputStream(file);
                fos.write(v.columnValue);
                fos.close();
            }
            catch (IOException e) {
                LOG.error("Error writing file", (Throwable)e);
                throw new RuntimeException("Error writing file", e);
            }
        }
    }

    @Override
    public void delete(String columnFamily, String sKey, String columnName) {
        if (columnName == null) {
            File dir = new File(this.main.getAbsoluteFile() + "/" + columnFamily + "/" + sKey);
            if (dir.exists()) {
                Utils.deleteDirectory((File)dir);
            }
        } else {
            File file = new File(this.main.getAbsoluteFile() + "/" + columnFamily + "/" + sKey + "/" + columnName.replace('/', '@'));
            if (file.exists()) {
                file.delete();
            }
        }
    }
}

