/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.io;

import com.dell.doradus.core.ServerConfig;
import com.dell.doradus.search.util.LRUSizeCache;

public class FileCache {
    private LRUSizeCache<String, byte[]> m_chunkCache;

    public FileCache() {
        int cacheSize = ServerConfig.getInstance().olap_file_cache_size_mb;
        if (cacheSize > 0) {
            this.m_chunkCache = new LRUSizeCache(0, (long)cacheSize * 1024L * 1024L);
        }
    }

    public boolean useCache() {
        return this.m_chunkCache != null;
    }

    public void put(String app, String key, String columnName, byte[] value) {
        if (this.m_chunkCache == null) {
            return;
        }
        String cacheKey = String.valueOf(app) + "/" + key + "/" + columnName;
        this.m_chunkCache.put(cacheKey, value, value.length + 2 * cacheKey.length() + 16);
    }

    public byte[] get(String app, String key, String columnName) {
        if (this.m_chunkCache == null) {
            return null;
        }
        byte[] cached = this.m_chunkCache.get(String.valueOf(app) + "/" + key + "/" + columnName);
        return cached;
    }
}

