/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.io;

import com.dell.doradus.common.Utils;
import com.dell.doradus.core.ServerConfig;
import com.dell.doradus.olap.io.ColumnValue;
import com.dell.doradus.olap.io.FileInfo;
import com.dell.doradus.olap.io.StorageHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class DataCache {
    private static int m_maxCachedColumns = 200;
    private Object m_staticSyncRoot = new Object();
    private static ExecutorService m_executor;
    private String m_storeName;
    private String m_row;
    private StorageHelper m_helper;
    private List<FileInfo> m_cachedInfos = null;
    private List<FileData> m_cachedData = null;
    private Object m_syncRoot = new Object();
    private List<Future<?>> m_futures = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataCache(String storeName, String row, StorageHelper helper) {
        int threads = ServerConfig.getInstance().olap_compression_threads;
        if (threads > 0) {
            Object object = this.m_staticSyncRoot;
            synchronized (object) {
                if (m_executor == null) {
                    m_executor = new ThreadPoolExecutor(threads, threads, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(threads), new ThreadPoolExecutor.CallerRunsPolicy());
                }
            }
        }
        this.m_storeName = storeName;
        this.m_row = row;
        this.m_helper = helper;
    }

    public boolean isMultithreaded() {
        return m_executor != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInfo(FileInfo info) {
        Object object = this.m_syncRoot;
        synchronized (object) {
            if (this.m_cachedInfos == null) {
                this.m_cachedInfos = new ArrayList<FileInfo>(m_maxCachedColumns);
            }
            this.m_cachedInfos.add(info);
            if (this.m_cachedInfos.size() >= m_maxCachedColumns) {
                this.flushCachedInfos();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addData(FileInfo info, byte[] data, int bufferNumber) {
        Object object = this.m_syncRoot;
        synchronized (object) {
            if (this.m_cachedData == null) {
                this.m_cachedData = new ArrayList<FileData>(m_maxCachedColumns);
            }
            this.m_cachedData.add(new FileData(info, data, bufferNumber));
            if (this.m_cachedData.size() >= m_maxCachedColumns) {
                this.flushCachedData();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRunnable(Runnable runnable) {
        Future<?> future = m_executor.submit(runnable);
        Object object = this.m_syncRoot;
        synchronized (object) {
            this.m_futures.add(future);
            if (this.m_futures.size() > m_maxCachedColumns) {
                this.flushPendingTasks();
            }
        }
    }

    public void flush() {
        this.flushPendingTasks();
        this.flushCachedData();
        this.flushCachedInfos();
    }

    private void flushPendingTasks() {
        if (this.m_futures.size() == 0) {
            return;
        }
        try {
            for (Future<?> f : this.m_futures) {
                f.get();
            }
            this.m_futures.clear();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private void flushCachedInfos() {
        if (this.m_cachedInfos == null || this.m_cachedInfos.size() == 0) {
            return;
        }
        ArrayList<ColumnValue> list = new ArrayList<ColumnValue>(this.m_cachedInfos.size());
        for (FileInfo fi : this.m_cachedInfos) {
            ColumnValue cv = new ColumnValue("File/" + fi.getName(), Utils.toBytes((String)fi.asString()));
            list.add(cv);
        }
        this.m_helper.write(this.m_storeName, this.m_row, list);
        this.m_cachedInfos.clear();
    }

    private void flushCachedData() {
        ColumnValue cv;
        FileInfo fi;
        if (this.m_cachedData == null || this.m_cachedData.size() == 0) {
            return;
        }
        ArrayList<ColumnValue> list = new ArrayList<ColumnValue>(this.m_cachedData.size());
        for (FileData d : this.m_cachedData) {
            fi = d.getInfo();
            if (fi.getSingleRow()) continue;
            if (!fi.getSharesRow()) {
                throw new RuntimeException("Not supported");
            }
            cv = new ColumnValue(String.valueOf(fi.getName()) + "/" + d.getBufferNumber(), d.getData());
            list.add(cv);
        }
        this.m_helper.writeFileChunks(this.m_storeName, String.valueOf(this.m_row) + "/_share", list);
        list.clear();
        for (FileData d : this.m_cachedData) {
            fi = d.getInfo();
            if (!fi.getSingleRow()) continue;
            cv = new ColumnValue("Data/" + fi.getName() + "/" + d.getBufferNumber(), d.getData());
            list.add(cv);
        }
        this.m_helper.writeFileChunks(this.m_storeName, this.m_row, list);
        this.m_cachedData.clear();
    }

    private static class FileData {
        private FileInfo m_fileInfo;
        private byte[] m_data;
        private int m_bufferNumber;

        public FileData(FileInfo fileInfo, byte[] data, int bufferNumber) {
            this.m_fileInfo = fileInfo;
            this.m_data = data;
            this.m_bufferNumber = bufferNumber;
        }

        public FileInfo getInfo() {
            return this.m_fileInfo;
        }

        public byte[] getData() {
            return this.m_data;
        }

        public int getBufferNumber() {
            return this.m_bufferNumber;
        }
    }
}

