/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.io;

import com.dell.doradus.core.ServerConfig;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class Compressor {
    private static boolean m_bCompress = ServerConfig.getInstance().olap_internal_compression;
    private static int m_compressionLevel = ServerConfig.getInstance().olap_compression_level;

    public static byte[] compress(byte[] data) {
        if (data.length == 0) {
            return data;
        }
        if (!m_bCompress) {
            return data;
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream gos = new GZIPOutputStream(baos){
                {
                    this.def.setLevel(m_compressionLevel);
                }
            };
            gos.write(data, 0, data.length);
            gos.close();
            byte[] output = baos.toByteArray();
            return output;
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static byte[] uncompress(byte[] data) {
        if (data.length == 0) {
            return data;
        }
        if (!m_bCompress) {
            return data;
        }
        try {
            int read;
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            GZIPInputStream gis = new GZIPInputStream(bais);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            while ((read = gis.read(buffer, 0, buffer.length)) >= 0) {
                baos.write(buffer, 0, read);
            }
            byte[] output = baos.toByteArray();
            return output;
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

