/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.io;

import com.dell.doradus.olap.io.ColumnValue;
import com.dell.doradus.olap.io.IO;
import com.dell.doradus.service.db.DBService;
import com.dell.doradus.service.db.DBTransaction;
import com.dell.doradus.service.db.DColumn;
import com.dell.doradus.service.db.Tenant;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CassandraIO
implements IO {
    private final Tenant m_tenant;

    public CassandraIO(Tenant tenant) {
        this.m_tenant = tenant;
    }

    @Override
    public byte[] getValue(String app, String key, String column) {
        DColumn col = DBService.instance().getColumn(this.m_tenant, app, key, column);
        if (col == null) {
            return null;
        }
        return col.getRawValue();
    }

    @Override
    public List<ColumnValue> get(String app, String key, String prefix) {
        ArrayList<ColumnValue> result = new ArrayList<ColumnValue>();
        Iterator<DColumn> iColumns = DBService.instance().getColumnSlice(this.m_tenant, app, key, prefix, String.valueOf(prefix) + "\uffff");
        while (iColumns.hasNext()) {
            DColumn column = iColumns.next();
            result.add(new ColumnValue(column.getName().substring(prefix.length()), column.getRawValue()));
        }
        return result;
    }

    @Override
    public void createCF(String name) {
    }

    @Override
    public void deleteCF(String name) {
    }

    @Override
    public void delete(String columnFamily, String key, String columnName) {
        DBTransaction transaction = DBService.instance().startTransaction(this.m_tenant);
        if (columnName == null) {
            transaction.deleteRow(columnFamily, key);
        } else {
            transaction.deleteColumn(columnFamily, key, columnName);
        }
        DBService.instance().commit(transaction);
    }

    @Override
    public void write(String app, String key, List<ColumnValue> values) {
        DBTransaction transaction = DBService.instance().startTransaction(this.m_tenant);
        for (ColumnValue v : values) {
            transaction.addColumn(app, key, v.columnName, v.columnValue);
        }
        DBService.instance().commit(transaction);
    }
}

