/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.io;

import com.dell.doradus.olap.io.Compressor;
import com.dell.doradus.olap.io.DataCache;
import com.dell.doradus.olap.io.FileInfo;
import com.dell.doradus.olap.io.IBufferWriter;
import com.dell.doradus.olap.io.StorageHelper;

public class BufferWriterRow
implements IBufferWriter {
    private StorageHelper m_helper;
    private String m_app;
    private String m_row;
    private DataCache m_dataCache;
    private Object m_syncRoot = new Object();
    private FileInfo m_info;

    public BufferWriterRow(DataCache dataCache, StorageHelper helper, String app, String row, String name) {
        this.m_dataCache = dataCache;
        this.m_helper = helper;
        this.m_app = app;
        this.m_row = row;
        this.m_info = new FileInfo(name);
        this.m_info.setSingleRow(true);
    }

    @Override
    public void writeBuffer(int bufferNumber, byte[] buffer, int length) {
        if (bufferNumber == 0 && length < buffer.length) {
            if (length < 512) {
                this.m_info.setUncompressed(true);
            }
            if (length < 65536 && !this.m_info.getSingleRow()) {
                this.m_info.setSharesRow(true);
            }
        }
        if (this.m_dataCache.isMultithreaded() && this.m_info.isCompressed()) {
            final int finalBufferNumber = bufferNumber;
            final byte[] buf = new byte[length];
            System.arraycopy(buffer, 0, buf, 0, length);
            this.m_dataCache.addRunnable(new Runnable(){

                @Override
                public void run() {
                    BufferWriterRow.this.write(finalBufferNumber, buf);
                }
            });
            return;
        }
        byte[] buf = buffer;
        if (length != buf.length) {
            buf = new byte[length];
            System.arraycopy(buffer, 0, buf, 0, buf.length);
        }
        this.write(bufferNumber, buf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(int bufferNumber, byte[] buf) {
        if (this.m_info.isCompressed()) {
            buf = Compressor.compress(buf);
        }
        Object object = this.m_syncRoot;
        synchronized (object) {
            this.m_info.setCompressedLength(this.m_info.getCompressedLength() + (long)buf.length);
        }
        if (this.m_info.getUncompressed()) {
            this.m_dataCache.addData(this.m_info, buf, bufferNumber);
            return;
        }
        if (this.m_info.getSingleRow()) {
            this.m_helper.writeFileChunk(this.m_app, this.m_row, "Data/" + this.m_info.getName() + "/" + bufferNumber, buf);
        } else if (this.m_info.getSharesRow()) {
            this.m_helper.writeFileChunk(this.m_app, String.valueOf(this.m_row) + "/_share", String.valueOf(this.m_info.getName()) + "/" + bufferNumber, buf);
        } else {
            this.m_helper.writeFileChunk(this.m_app, String.valueOf(this.m_row) + "/" + this.m_info.getName(), "" + bufferNumber, buf);
        }
    }

    @Override
    public void close(long length) {
        this.m_info.setLength(length);
        this.m_dataCache.addInfo(this.m_info);
    }
}

