/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.io;

import com.dell.doradus.common.Utils;
import com.dell.doradus.olap.io.Utf8Encoder;

public class BSTR
implements Comparable<BSTR> {
    public static final BSTR EMPTY = new BSTR(new byte[0]);
    public byte[] buffer;
    public int length;

    public BSTR() {
        this.buffer = new byte[16384];
    }

    public void assertLength(int length) {
        if (this.buffer == null || this.buffer.length < length) {
            byte[] newbuffer = new byte[length * 2];
            for (int i = 0; i < this.buffer.length; ++i) {
                newbuffer[i] = this.buffer[i];
            }
            this.buffer = newbuffer;
        }
    }

    public BSTR(String str) {
        this.buffer = Utils.toBytes((String)str);
        this.length = this.buffer.length;
    }

    public BSTR(BSTR other) {
        this.length = other.length;
        if (this.length < 0) {
            this.length = 0;
        }
        this.buffer = new byte[this.length];
        System.arraycopy(other.buffer, 0, this.buffer, 0, this.length);
    }

    public BSTR(byte[] bytes) {
        this.buffer = bytes;
        this.length = this.buffer.length;
    }

    public BSTR(byte[] bytes, int offset, int length) {
        this.buffer = new byte[length];
        System.arraycopy(bytes, offset, this.buffer, 0, length);
        this.length = this.buffer.length;
    }

    public BSTR(double value) {
        this(value < 0.0 ? -Double.doubleToLongBits(-value) : Double.doubleToLongBits(value));
    }

    public BSTR(long value) {
        value = value >= 0L ? value + Long.MIN_VALUE : value - Long.MIN_VALUE;
        this.length = 8;
        this.buffer = new byte[8];
        this.buffer[7] = (byte)value;
        this.buffer[6] = (byte)(value >>>= 8);
        this.buffer[5] = (byte)(value >>>= 8);
        this.buffer[4] = (byte)(value >>>= 8);
        this.buffer[3] = (byte)(value >>>= 8);
        this.buffer[2] = (byte)(value >>>= 8);
        this.buffer[1] = (byte)(value >>>= 8);
        this.buffer[0] = (byte)(value >>>= 8);
    }

    public void set(Utf8Encoder encoder, String value) {
        this.assertLength(value.length() * 4);
        this.length = encoder.encode(value, this.buffer);
    }

    public void set(BSTR other) {
        this.set(other.buffer, other.length);
    }

    public void set(byte[] data) {
        this.set(data, data.length);
    }

    private void set(byte[] data, int len) {
        this.assertLength(len);
        System.arraycopy(data, 0, this.buffer, 0, len);
        this.length = len;
    }

    @Override
    public int compareTo(BSTR other) {
        return BSTR.compare(this, other);
    }

    public boolean equals(Object obj) {
        if (obj instanceof BSTR) {
            return BSTR.isEqual(this, (BSTR)obj);
        }
        return false;
    }

    public int hashCode() {
        return BSTR.hashCode(this);
    }

    public String toString() {
        return new String(this.buffer, 0, this.length, Utils.UTF8_CHARSET);
    }

    public static int compare(BSTR x, BSTR y) {
        int l = Math.min(x.length, y.length);
        for (int i = 0; i < l; ++i) {
            char bx = (char)x.buffer[i];
            char by = (char)y.buffer[i];
            if (bx < by) {
                return -1;
            }
            if (bx <= by) continue;
            return 1;
        }
        if (x.length < y.length) {
            return -1;
        }
        if (x.length > y.length) {
            return 1;
        }
        return 0;
    }

    public static boolean isEqual(BSTR x, BSTR y) {
        if (x == y) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        if (x.length != y.length) {
            return false;
        }
        for (int i = 0; i < x.length; ++i) {
            if (x.buffer[i] == y.buffer[i]) continue;
            return false;
        }
        return true;
    }

    public static int hashCode(BSTR x) {
        int c = 0;
        for (int i = 0; i < x.length; ++i) {
            c *= 31;
            c += x.buffer[i];
        }
        return c;
    }
}

