/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.collections.strings;

import com.dell.doradus.olap.collections.ArrayOperations;
import com.dell.doradus.olap.collections.IIntComparer;
import com.dell.doradus.olap.collections.QuickSorter;
import com.dell.doradus.olap.collections.UTF8;
import com.dell.doradus.olap.io.BSTR;

public class StringList
implements IIntComparer {
    private char[] m_buffer = new char[65536];
    private int m_bufferPosition;
    private int[] m_lengths = new int[256];
    private int m_lengthPosition;
    private UTF8 m_utf8 = new UTF8();
    private BSTR m_temp = new BSTR(1024L);
    private BSTR m_temp_lowercase = new BSTR(1024L);
    private char[] m_temp_for_lowercase = new char[1024];

    public void clear() {
        this.m_bufferPosition = 0;
        this.m_lengthPosition = 0;
    }

    public int add(String value) {
        if (value == null) {
            value = "";
        }
        int index = this.m_lengthPosition / 2;
        int length = value.length();
        this.ensureCapacity(length);
        ArrayOperations.copy(value, this.m_buffer, this.m_bufferPosition);
        this.m_lengths[this.m_lengthPosition++] = length;
        this.m_lengths[this.m_lengthPosition++] = this.m_bufferPosition;
        this.m_bufferPosition += length;
        return index;
    }

    public void set(int index, String value) {
        int lengthPosition = index * 2;
        if (lengthPosition < 0 || lengthPosition > this.m_lengthPosition - 2) {
            throw new RuntimeException("Invalid Index");
        }
        if (value == null) {
            value = "";
        }
        int length = value.length();
        this.ensureCapacity(length);
        ArrayOperations.copy(value, this.m_buffer, this.m_bufferPosition);
        this.m_lengths[lengthPosition++] = length;
        this.m_lengths[lengthPosition++] = this.m_bufferPosition;
        this.m_bufferPosition += length;
    }

    public String get(int index) {
        int xlen = this.m_lengths[index *= 2];
        int xpos = this.m_lengths[index + 1];
        return new String(this.m_buffer, xpos, xlen);
    }

    public BSTR getBinary(int index) {
        int xlen = this.m_lengths[index *= 2];
        int xpos = this.m_lengths[index + 1];
        this.m_temp.assertLength(xlen * 4);
        this.m_temp.length = this.m_utf8.encode(this.m_buffer, xpos, xlen, this.m_temp.buffer, 0);
        return this.m_temp;
    }

    public BSTR getBinaryLowercase(int index) {
        int xlen = this.m_lengths[index *= 2];
        int xpos = this.m_lengths[index + 1];
        if (this.m_temp_for_lowercase == null || this.m_temp_for_lowercase.length < xlen) {
            this.m_temp_for_lowercase = new char[xlen * 2];
        }
        ArrayOperations.copy(this.m_buffer, xpos, this.m_temp_for_lowercase, 0, xlen);
        UTF8.toLower(this.m_temp_for_lowercase, 0, xlen);
        this.m_temp_lowercase.assertLength(xlen * 4);
        this.m_temp_lowercase.length = this.m_utf8.encode(this.m_temp_for_lowercase, 0, xlen, this.m_temp_lowercase.buffer, 0);
        return this.m_temp_lowercase;
    }

    public int size() {
        return this.m_lengthPosition / 2;
    }

    public int[] sort() {
        int[] array = new int[this.size()];
        int i = 0;
        while (i < array.length) {
            array[i] = i;
            ++i;
        }
        this.sort(array, array.length);
        return array;
    }

    public void sort(int[] array, int length) {
        QuickSorter.sort(this, array, 0, length);
    }

    private void ensureCapacity(int length) {
        while (this.m_bufferPosition + length > this.m_buffer.length) {
            this.m_buffer = ArrayOperations.realloc(this.m_buffer, this.m_buffer.length * 2);
        }
        if (this.m_lengthPosition == this.m_lengths.length) {
            this.m_lengths = ArrayOperations.realloc(this.m_lengths, this.m_lengths.length * 2);
        }
    }

    @Override
    public boolean isEqual(int x, int y) {
        int xlen = this.m_lengths[x *= 2];
        int ylen = this.m_lengths[y *= 2];
        int xpos = this.m_lengths[x + 1];
        int ypos = this.m_lengths[y + 1];
        return ArrayOperations.isEqual(this.m_buffer, xpos, xlen, this.m_buffer, ypos, ylen);
    }

    @Override
    public int getHash(int x) {
        int xlen = this.m_lengths[x *= 2];
        int xpos = this.m_lengths[x + 1];
        return ArrayOperations.getHash(this.m_buffer, xpos, xlen);
    }

    @Override
    public int compare(int x, int y) {
        int xlen = this.m_lengths[x *= 2];
        int ylen = this.m_lengths[y *= 2];
        int xpos = this.m_lengths[x + 1];
        int ypos = this.m_lengths[y + 1];
        return ArrayOperations.compare(this.m_buffer, xpos, xlen, this.m_buffer, ypos, ylen);
    }

    @Override
    public int getHash(Object o) {
        if (o instanceof String) {
            String str = (String)o;
            char[] chars = str.toCharArray();
            return ArrayOperations.getHash(chars, 0, chars.length);
        }
        return o.hashCode();
    }

    @Override
    public boolean isEqual(Object o, int y) {
        int ylen = this.m_lengths[y *= 2];
        int ypos = this.m_lengths[y + 1];
        if (o instanceof String) {
            String str = (String)o;
            char[] chars = str.toCharArray();
            return ArrayOperations.isEqual(chars, 0, chars.length, this.m_buffer, ypos, ylen);
        }
        return o.equals(this.get(y));
    }
}

