/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.collections;

import com.dell.doradus.common.Utils;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;

public final class UTF8 {
    private final CharsetEncoder utf8_encoder = Utils.UTF8_CHARSET.newEncoder();
    private final CharsetDecoder utf8_decoder = Utils.UTF8_CHARSET.newDecoder();

    public static void toLower(char[] src, int srcOffset, int srcLength) {
        int end = srcOffset + srcLength;
        int i = srcOffset;
        while (i < end) {
            char c = src[i];
            if (c < '\u0080') {
                if (c >= 'A' && c <= 'Z') {
                    c = (char)(c + 32);
                }
                src[i] = c;
            } else {
                src[i] = Character.toLowerCase(c);
            }
            ++i;
        }
    }

    public int encode(char[] src, int srcOffset, int srcLength, byte[] dst, int dstOffset) {
        int i = 0;
        while (i < srcLength) {
            if (src[srcOffset + i] > '\u0080') {
                int len = this.encodeInternal(src, srcOffset + i, srcLength - i, dst, dstOffset + i);
                return i + len;
            }
            dst[dstOffset + i] = (byte)src[srcOffset + i];
            ++i;
        }
        return srcLength;
    }

    public int decode(byte[] src, int srcOffset, int srcLength, char[] dst, int dstOffset) {
        int i = 0;
        while (i < srcLength) {
            if (src[srcOffset + i] < 0) {
                int len = this.decodeInternal(src, srcOffset + i, srcLength - i, dst, dstOffset + i);
                return i + len;
            }
            dst[dstOffset + i] = (char)src[srcOffset + i];
            ++i;
        }
        return srcLength;
    }

    private int encodeInternal(char[] src, int srcOffset, int srcLength, byte[] dst, int dstOffset) {
        CharBuffer cb = CharBuffer.wrap(src, srcOffset, srcLength);
        ByteBuffer bb = ByteBuffer.wrap(dst, dstOffset, dst.length - dstOffset);
        this.utf8_encoder.reset();
        this.utf8_encoder.encode(cb, bb, true);
        this.utf8_encoder.flush(bb);
        int length = bb.position() - dstOffset;
        return length;
    }

    private int decodeInternal(byte[] src, int srcOffset, int srcLength, char[] dst, int dstOffset) {
        ByteBuffer bb = ByteBuffer.wrap(src, srcOffset, srcLength);
        CharBuffer cb = CharBuffer.wrap(dst, dstOffset, dst.length - dstOffset);
        this.utf8_decoder.reset();
        this.utf8_decoder.decode(bb, cb, true);
        this.utf8_decoder.flush(cb);
        int length = cb.position() - dstOffset;
        return length;
    }
}

