/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.collections;

import com.dell.doradus.olap.collections.NumericUtils;

public class SimpleIntSet {
    private int m_capacity;
    private int m_size = 0;
    private int m_mask;
    private int[] m_indexes;

    public SimpleIntSet(int capacity) {
        this.m_capacity = NumericUtils.nextPowerOfTwo(capacity);
        this.m_mask = capacity * 2 - 1;
        this.m_indexes = new int[this.m_capacity * 2];
        int i = 0;
        while (i < this.m_indexes.length) {
            this.m_indexes[i] = -1;
            ++i;
        }
    }

    public int size() {
        return this.m_size;
    }

    public void clear() {
        this.m_size = 0;
        int i = 0;
        while (i < this.m_indexes.length) {
            this.m_indexes[i] = -1;
            ++i;
        }
    }

    public int[] getBuffer() {
        return this.m_indexes;
    }

    public boolean add(int value) {
        int hash;
        int pos;
        int index;
        if (value < 0) {
            throw new RuntimeException("Cannot add negative numbers");
        }
        if (this.m_size == this.m_capacity) {
            this.resize();
        }
        if ((index = this.m_indexes[pos = (hash = value) & this.m_mask]) == value) {
            return false;
        }
        if (index < 0) {
            this.m_indexes[pos] = value;
            ++this.m_size;
            return true;
        }
        int inc = (hash >> 8) + hash | 1;
        do {
            if ((index = this.m_indexes[pos = pos + inc & this.m_mask]) != value) continue;
            return false;
        } while (index >= 0);
        this.m_indexes[pos] = value;
        ++this.m_size;
        return true;
    }

    private int findSlot(int i) {
        int hash = i;
        int pos = hash & this.m_mask;
        int index = this.m_indexes[pos];
        if (index < 0) {
            return pos;
        }
        int inc = (hash >> 8) + hash | 1;
        while ((index = this.m_indexes[pos = pos + inc & this.m_mask]) >= 0) {
        }
        return pos;
    }

    private void resize() {
        this.m_capacity *= 2;
        this.m_mask = this.m_capacity * 2 - 1;
        this.reindex();
    }

    private void reindex() {
        int[] oldindexes = this.m_indexes;
        this.m_indexes = new int[this.m_capacity * 2];
        int i = 0;
        while (i < this.m_indexes.length) {
            this.m_indexes[i] = -1;
            ++i;
        }
        i = 0;
        while (i < oldindexes.length) {
            int val = oldindexes[i];
            if (val != -1) {
                int pos = this.findSlot(val);
                this.m_indexes[pos] = val;
            }
            ++i;
        }
    }
}

