/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.collections;

public class NumericUtils {
    public static int bits(long maxValue) {
        int bits = 0;
        while (maxValue != 0L) {
            ++bits;
            maxValue >>>= 1;
        }
        return bits;
    }

    public static long mask(int bits) {
        if (bits > 64 || bits < 0) {
            throw new RuntimeException("Wrong number of bits: " + bits);
        }
        return bits == 64 ? -1L : (1L << bits) - 1L;
    }

    public static int nextPowerOfTwo(int x) {
        if ((x & x - 1) != 0) {
            x = Integer.highestOneBit(x) * 2;
        }
        if ((x & x - 1) != 0) {
            throw new RuntimeException("Error in nextPowerOfTwo");
        }
        return x;
    }

    public static long gcd(long x, long y) {
        if (x < 0L) {
            x = -x;
        }
        if (y < 0L) {
            y = -y;
        }
        if (x < y) {
            long temp = x;
            x = y;
            y = temp;
        }
        long gcd = 1L;
        while (y > 1L) {
            if ((x & 1L) == 0L) {
                if ((y & 1L) == 0L) {
                    gcd <<= 1;
                    x >>= 1;
                    y >>= 1;
                } else {
                    x >>= 1;
                }
            } else if ((y & 1L) == 0L) {
                y >>= 1;
            } else {
                x = x - y >> 1;
            }
            if (x >= y) continue;
            long temp = x;
            x = y;
            y = temp;
        }
        return y == 1L ? gcd : gcd * x;
    }
}

