/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.collections;

import com.dell.doradus.olap.io.BSTR;

public class MemoryStream {
    private byte[] m_buffer;
    private int m_length;
    private int m_position;
    private BSTR m_bstr = new BSTR();

    public MemoryStream() {
        this.m_buffer = new byte[1024];
    }

    public MemoryStream(int capacity) {
        this.m_buffer = new byte[capacity];
    }

    public MemoryStream(byte[] buffer) {
        this.m_buffer = buffer;
        this.m_length = buffer.length;
    }

    public int length() {
        return this.m_length;
    }

    public int position() {
        return this.m_position;
    }

    public boolean end() {
        return this.m_position == this.m_length;
    }

    public void clear() {
        this.m_position = 0;
        this.m_length = 0;
    }

    public void seek(int position) {
        if (position < 0) {
            throw new RuntimeException("Cannot seek before the start");
        }
        if (position > this.m_length) {
            throw new RuntimeException("Cannot seek past the end");
        }
        this.m_position = position;
    }

    public void skip(int bytes) {
        this.seek(this.m_position + bytes);
    }

    public byte[] getBuffer() {
        return this.m_buffer;
    }

    public byte[] toArray() {
        byte[] buf = new byte[this.m_length];
        System.arraycopy(this.m_buffer, 0, buf, 0, this.m_length);
        return buf;
    }

    private void assertLength(int newLength) {
        int length = this.m_buffer.length;
        if (length >= newLength) {
            return;
        }
        while (length < newLength) {
            length *= 2;
        }
        byte[] buf = new byte[length];
        System.arraycopy(this.m_buffer, 0, buf, 0, this.m_length);
        this.m_buffer = buf;
    }

    public void read(byte[] buffer, int offset, int count) {
        if (count > this.m_length - this.m_position) {
            throw new RuntimeException("End of buffer");
        }
        System.arraycopy(this.m_buffer, this.m_position, buffer, offset, count);
        this.m_position += count;
    }

    public int readByte() {
        if (this.m_position >= this.m_length) {
            throw new RuntimeException("End of buffer");
        }
        return this.m_buffer[this.m_position++] & 0xFF;
    }

    public int readVInt() {
        int b = this.readByte();
        int u = b & 0x7F;
        int shift = 7;
        while (b > 127) {
            b = this.readByte();
            u += (b & 0x7F) << shift;
            shift += 7;
        }
        return u;
    }

    public long readVLong() {
        long b = this.readByte();
        long u = b & 0x7FL;
        int shift = 7;
        while (b > 127L) {
            b = this.readByte();
            u += (b & 0x7FL) << shift;
            shift += 7;
        }
        return u;
    }

    public short readShort() {
        int u = this.readByte() | this.readByte() << 8;
        return (short)u;
    }

    public int readInt() {
        int u = this.readByte() | this.readByte() << 8 | this.readByte() << 16 | this.readByte() << 24;
        return u;
    }

    public long readLong() {
        long u = (long)this.readByte() | (long)this.readByte() << 8 | (long)this.readByte() << 16 | (long)this.readByte() << 24 | (long)this.readByte() << 32 | (long)this.readByte() << 40 | (long)this.readByte() << 48 | (long)this.readByte() << 56;
        return u;
    }

    public double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    public BSTR readString() {
        int len = this.readVInt();
        this.m_bstr.assertLength(len);
        this.read(this.m_bstr.buffer, 0, len);
        this.m_bstr.length = len;
        return this.m_bstr;
    }

    public void writeByte(byte value) {
        this.assertLength(this.m_position + 1);
        this.m_buffer[this.m_position++] = value;
        if (this.m_position > this.m_length) {
            this.m_length = this.m_position;
        }
    }

    public void write(byte[] buffer, int offset, int count) {
        this.assertLength(this.m_position + count);
        System.arraycopy(buffer, offset, this.m_buffer, this.m_position, count);
        this.m_position += count;
        if (this.m_position > this.m_length) {
            this.m_length = this.m_position;
        }
    }

    public void writeVInt(int value) {
        for (int u = value >>> 7; u != 0; u >>>= 7) {
            this.writeByte((byte)(value & 0x7F | 0x80));
            value = u;
        }
        this.writeByte((byte)value);
    }

    public void writeVLong(long value) {
        for (long u = value >>> 7; u != 0L; u >>>= 7) {
            this.writeByte((byte)(value & 0x7FL | 0x80L));
            value = u;
        }
        this.writeByte((byte)value);
    }

    public void writeShort(short value) {
        short u = value;
        this.writeByte((byte)u);
        u = (short)(u >>> 8);
        this.writeByte((byte)u);
    }

    public void writeInt(int value) {
        int u = value;
        this.writeByte((byte)u);
        this.writeByte((byte)(u >>>= 8));
        this.writeByte((byte)(u >>>= 8));
        this.writeByte((byte)(u >>>= 8));
    }

    public void writeLong(long value) {
        long u = value;
        this.writeByte((byte)u);
        this.writeByte((byte)(u >>>= 8));
        this.writeByte((byte)(u >>>= 8));
        this.writeByte((byte)(u >>>= 8));
        this.writeByte((byte)(u >>>= 8));
        this.writeByte((byte)(u >>>= 8));
        this.writeByte((byte)(u >>>= 8));
        this.writeByte((byte)(u >>>= 8));
        u >>>= 8;
    }

    public void writeDouble(double value) {
        this.writeLong(Double.doubleToLongBits(value));
    }

    public void writeString(BSTR bstr) {
        this.writeVInt(bstr.length);
        this.write(bstr.buffer, 0, bstr.length);
    }
}

