/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.collections;

import com.dell.doradus.olap.collections.ArrayOperations;
import com.dell.doradus.olap.collections.IIntComparer;
import com.dell.doradus.olap.collections.NumericUtils;

public class IntSet {
    private int m_capacity;
    private int m_size;
    private int m_mask;
    private int[] m_values;
    private int[] m_hashes;
    private int[] m_indexes;
    private IIntComparer m_comparer;

    public IntSet(IIntComparer comparer, int capacity) {
        this.m_comparer = comparer;
        this.m_size = 0;
        this.m_capacity = NumericUtils.nextPowerOfTwo(capacity);
        this.m_mask = capacity * 2 - 1;
        this.m_values = new int[capacity];
        this.m_hashes = new int[capacity];
        this.reindex();
    }

    public int size() {
        return this.m_size;
    }

    public int get(int index) {
        return this.m_values[index];
    }

    public int add(int value) {
        int index;
        if (this.m_size == this.m_capacity) {
            this.resize();
        }
        if ((index = this.indexOf(value)) >= 0) {
            this.m_values[index] = value;
            return index;
        }
        int pos = -index - 1;
        this.m_indexes[pos] = this.m_size;
        this.m_values[this.m_size] = value;
        this.m_hashes[this.m_size] = this.m_comparer.getHash(value);
        return this.m_size++;
    }

    public int indexOf(Object value) {
        int hash = this.m_comparer.getHash(value);
        int pos = hash & this.m_mask;
        int index = this.m_indexes[pos];
        if (index < 0) {
            return -pos - 1;
        }
        if (hash == this.m_hashes[index] && this.m_comparer.isEqual(value, this.m_values[index])) {
            return index;
        }
        int inc = (hash >> 8) + hash | 1;
        do {
            if ((index = this.m_indexes[pos = pos + inc & this.m_mask]) >= 0) continue;
            return -pos - 1;
        } while (hash != this.m_hashes[index] || !this.m_comparer.isEqual(value, this.m_values[index]));
        return index;
    }

    public int indexOf(int value) {
        int hash = this.m_comparer.getHash(value);
        int pos = hash & this.m_mask;
        int index = this.m_indexes[pos];
        if (index < 0) {
            return -pos - 1;
        }
        if (hash == this.m_hashes[index] && this.m_comparer.isEqual(value, this.m_values[index])) {
            return index;
        }
        int inc = (hash >> 8) + hash | 1;
        do {
            if ((index = this.m_indexes[pos = pos + inc & this.m_mask]) >= 0) continue;
            return -pos - 1;
        } while (hash != this.m_hashes[index] || !this.m_comparer.isEqual(value, this.m_values[index]));
        return index;
    }

    private int findSlot(int i) {
        int hash = this.m_hashes[i];
        int pos = hash & this.m_mask;
        int index = this.m_indexes[pos];
        if (index < 0) {
            return pos;
        }
        int inc = (hash >> 8) + hash | 1;
        while ((index = this.m_indexes[pos = pos + inc & this.m_mask]) >= 0) {
        }
        return pos;
    }

    private void resize() {
        this.m_capacity *= 2;
        this.m_mask = this.m_capacity * 2 - 1;
        this.m_values = ArrayOperations.realloc(this.m_values, this.m_capacity);
        this.m_hashes = ArrayOperations.realloc(this.m_hashes, this.m_capacity);
        this.reindex();
    }

    private void reindex() {
        this.m_indexes = new int[this.m_capacity * 2];
        int i = 0;
        while (i < this.m_indexes.length) {
            this.m_indexes[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.m_size) {
            int pos = this.findSlot(i);
            this.m_indexes[pos] = i++;
        }
    }
}

