/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.collections;

import com.dell.doradus.olap.collections.IIntComparer;

public class HeapSorter {
    public static void sort(IIntComparer comparator, int[] buffer, int offset, int length) {
        int i = 1;
        while (i < length) {
            HeapSorter.upHeap(comparator, buffer, offset, i);
            ++i;
        }
        i = length - 1;
        while (i > 0) {
            int node = buffer[offset + i];
            buffer[offset + i] = buffer[offset];
            buffer[offset] = node;
            HeapSorter.downHeap(comparator, buffer, offset, i);
            --i;
        }
    }

    private static void upHeap(IIntComparer comparator, int[] buffer, int start, int index) {
        int node = buffer[--start + ++index];
        int j = index >> 1;
        while (j > 0 && comparator.compare(node, buffer[start + j]) > 0) {
            buffer[start + index] = buffer[start + j];
            index = j;
            j = index >> 1;
        }
        buffer[start + index] = node;
    }

    private static void downHeap(IIntComparer comparator, int[] buffer, int start, int length) {
        int i = 1;
        int node = buffer[--start + i];
        int j = i << 1;
        int k = j + 1;
        if (k <= length && comparator.compare(buffer[start + k], buffer[start + j]) > 0) {
            j = k;
        }
        while (j <= length && comparator.compare(buffer[start + j], node) > 0) {
            buffer[start + i] = buffer[start + j];
            i = j;
            k = (j = i << 1) + 1;
            if (k > length || comparator.compare(buffer[start + k], buffer[start + j]) <= 0) continue;
            j = k;
        }
        buffer[start + i] = node;
    }
}

