/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.collections;

import com.dell.doradus.olap.collections.NumericUtils;

public class BitPacker {
    public static int bits(long maxValue) {
        return NumericUtils.bits(maxValue);
    }

    public static int pack(long[] input, long[] output, int count, int bits) {
        if (bits == 0) {
            return 0;
        }
        if (bits == 64) {
            int i = 0;
            while (i < count) {
                output[i] = input[i];
                ++i;
            }
            return count;
        }
        int i = 0;
        while (i < output.length) {
            output[i] = 0L;
            ++i;
        }
        int index = 0;
        int offset = 0;
        long mask = NumericUtils.mask(bits);
        int i2 = 0;
        while (i2 < count) {
            long value = input[i2] & mask;
            int n = index++;
            output[n] = output[n] | value << offset;
            if (offset + bits <= 64) {
                if ((offset += bits) == 64) {
                    offset = 0;
                }
            } else {
                int n2 = ++index;
                output[n2] = output[n2] | value >>> 64 - offset;
                offset = offset + bits - 64;
            }
            ++i2;
        }
        return (count * bits + 63) / 64;
    }

    public static void unpack(long[] input, long[] output, int count, int bits) {
        if (bits == 64) {
            int i = 0;
            while (i < count) {
                output[i] = input[i];
                ++i;
            }
            return;
        }
        int index = 0;
        int offset = 0;
        long mask = NumericUtils.mask(bits);
        int i = 0;
        while (i < count) {
            long value = input[index] >>> offset;
            if (offset + bits <= 64) {
                if ((offset += bits) == 64) {
                    offset = 0;
                    ++index;
                }
            } else {
                value |= input[++index] << 64 - offset;
                offset = offset + bits - 64;
            }
            output[i] = value & mask;
            ++i;
        }
    }

    public static void set(long value, long[] output, int start, int bits, int pos) {
        if (bits == 64) {
            output[start + pos] = value;
            return;
        }
        int index = start + pos * bits / 64;
        int offset = pos * bits % 64;
        long mask = NumericUtils.mask(bits);
        int n = index++;
        output[n] = output[n] | (value &= mask) << offset;
        if (offset + bits > 64) {
            int n2 = index;
            output[n2] = output[n2] | value >>> 64 - offset;
        }
    }

    public static long get(long[] input, int start, int bits, int pos) {
        if (bits == 0) {
            return 0L;
        }
        if (bits == 64) {
            return input[start + pos];
        }
        int index = start + pos * bits / 64;
        int offset = pos * bits % 64;
        long mask = NumericUtils.mask(bits);
        long value = input[index] >>> offset;
        if (offset + bits > 64) {
            value |= input[++index] << 64 - offset;
        }
        return value & mask;
    }
}

