/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.collections;

import com.dell.doradus.olap.collections.NumericUtils;
import java.util.Arrays;

public class BdLongSet {
    private long[] m_values;
    private int[] m_valueIndexes;
    private int m_size = 0;
    private int m_mask;
    private int[] m_indexBuffer;
    private boolean m_bSorted;

    public BdLongSet(int capacity) {
        capacity = NumericUtils.nextPowerOfTwo(capacity);
        this.m_mask = capacity * 2 - 1;
        this.m_values = new long[capacity];
        this.m_indexBuffer = new int[capacity * 2];
        int i = 0;
        while (i < this.m_indexBuffer.length) {
            this.m_indexBuffer[i] = -1;
            ++i;
        }
    }

    public void enableClearBuffer() {
        if (this.m_size > 0) {
            throw new RuntimeException("Cannot enable clearing on non-empty set");
        }
        this.m_valueIndexes = new int[this.m_values.length];
    }

    public int size() {
        return this.m_size;
    }

    public long get(int index) {
        return this.m_values[index];
    }

    public int indexOf(long value) {
        if (this.m_bSorted) {
            throw new RuntimeException("Cannot add to sorted set");
        }
        int hash = this.getHash(value);
        int pos = hash & this.m_mask;
        int index = this.m_indexBuffer[pos];
        if (index < 0) {
            return -pos - 1;
        }
        if (this.m_values[index] == value) {
            return index;
        }
        int inc = (hash >> 8) + hash | 1;
        do {
            if ((index = this.m_indexBuffer[pos = (hash += inc) & this.m_mask]) >= 0) continue;
            return -pos - 1;
        } while (this.m_values[index] != value);
        return index;
    }

    public int add(long value) {
        int index;
        if (this.m_bSorted) {
            throw new RuntimeException("Cannot add to sorted set");
        }
        if (this.m_size == this.m_values.length) {
            this.resize();
        }
        if ((index = this.indexOf(value)) >= 0) {
            return index;
        }
        int pos = -index - 1;
        this.m_indexBuffer[pos] = this.m_size;
        this.m_values[this.m_size] = value;
        if (this.m_valueIndexes != null) {
            this.m_valueIndexes[this.m_size] = pos;
        }
        return this.m_size++;
    }

    public void addAll(BdLongSet values) {
        int i = 0;
        while (i < values.size()) {
            this.add(values.get(i));
            ++i;
        }
    }

    public void sort() {
        Arrays.sort(this.m_values, 0, this.m_size);
        this.m_bSorted = true;
    }

    /*
     * Unable to fully structure code
     */
    public void clear() {
        if (this.m_valueIndexes != null) ** GOTO lbl5
        throw new RuntimeException("Clearing is not enabled");
lbl-1000:
        // 1 sources

        {
            --this.m_size;
            this.m_indexBuffer[this.m_valueIndexes[this.m_size]] = -1;
lbl5:
            // 2 sources

            ** while (this.m_size > 0)
        }
lbl6:
        // 1 sources

        this.m_bSorted = false;
    }

    public void restoreAfterSort() {
        if (!this.m_bSorted) {
            return;
        }
        this.m_bSorted = false;
        int i = 0;
        while (i < this.m_indexBuffer.length) {
            this.m_indexBuffer[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.m_size) {
            int pos = this.findSlot(this.m_values[i]);
            this.m_indexBuffer[pos] = i;
            if (this.m_valueIndexes != null) {
                this.m_valueIndexes[i] = pos;
            }
            ++i;
        }
    }

    private int findSlot(long value) {
        int hash = this.getHash(value);
        int pos = hash & this.m_mask;
        int index = this.m_indexBuffer[pos];
        if (index < 0) {
            return pos;
        }
        int inc = (hash >> 8) + hash | 1;
        while ((index = this.m_indexBuffer[pos = (hash += inc) & this.m_mask]) >= 0) {
        }
        return pos;
    }

    private void resize() {
        long[] values = this.m_values;
        int capacity = this.m_indexBuffer.length;
        this.m_mask = capacity * 2 - 1;
        this.m_values = new long[capacity];
        if (this.m_valueIndexes != null) {
            this.m_valueIndexes = new int[capacity];
        }
        this.m_indexBuffer = new int[capacity * 2];
        int i = 0;
        while (i < this.m_indexBuffer.length) {
            this.m_indexBuffer[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.m_size) {
            this.m_values[i] = values[i];
            int pos = this.findSlot(values[i]);
            this.m_indexBuffer[pos] = i;
            if (this.m_valueIndexes != null) {
                this.m_valueIndexes[i] = pos;
            }
            ++i;
        }
    }

    private int getHash(long value) {
        return (int)(value ^ value >>> 32);
    }
}

