/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.collections;

import com.dell.doradus.olap.collections.NumericUtils;

public abstract class BdIntSet {
    private int m_capacity;
    private int m_size = 0;
    private int m_mask;
    private int[] m_indexBuffer;

    public BdIntSet(int capacity) {
        this.m_capacity = NumericUtils.nextPowerOfTwo(capacity);
        this.m_mask = capacity * 2 - 1;
        this.m_indexBuffer = new int[capacity * 2];
        int i = 0;
        while (i < this.m_indexBuffer.length) {
            this.m_indexBuffer[i] = -1;
            ++i;
        }
    }

    protected abstract int getHashCode(int var1);

    protected abstract boolean isEqual(int var1, int var2);

    public int add(int value) {
        int index;
        if (value != this.m_size) {
            throw new RuntimeException("Cannot add values out of order");
        }
        if (this.m_size == this.m_capacity) {
            this.resize();
        }
        if ((index = this.indexOf(value)) >= 0) {
            return index;
        }
        int pos = -index - 1;
        this.m_indexBuffer[pos] = value;
        return this.m_size++;
    }

    private int indexOf(int value) {
        int hash = this.getHashCode(value) & 0x1FFFFFFF;
        int pos = hash & this.m_mask;
        int index = this.m_indexBuffer[pos];
        if (index < 0) {
            return -pos - 1;
        }
        if (this.isEqual(index, value)) {
            return index;
        }
        int inc = (hash >> 8) + hash | 1;
        do {
            if ((index = this.m_indexBuffer[pos = (hash += inc) & this.m_mask]) >= 0) continue;
            return -pos - 1;
        } while (!this.isEqual(index, value));
        return index;
    }

    private int findSlot(int value) {
        int hash = this.getHashCode(value) & 0x1FFFFFFF;
        int pos = hash & this.m_mask;
        int index = this.m_indexBuffer[pos];
        if (index < 0) {
            return pos;
        }
        int inc = (hash >> 8) + hash | 1;
        while ((index = this.m_indexBuffer[pos = (hash += inc) & this.m_mask]) >= 0) {
        }
        return pos;
    }

    private void resize() {
        this.m_capacity *= 2;
        this.m_mask = this.m_capacity * 2 - 1;
        int[] indexBuffer = this.m_indexBuffer;
        this.m_indexBuffer = new int[this.m_capacity * 2];
        int i = 0;
        while (i < this.m_indexBuffer.length) {
            this.m_indexBuffer[i] = -1;
            ++i;
        }
        i = 0;
        while (i < indexBuffer.length) {
            int value = indexBuffer[i];
            if (value >= 0) {
                int pos = this.findSlot(value);
                this.m_indexBuffer[pos] = i;
            }
            ++i;
        }
    }
}

