/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.builder;

import com.dell.doradus.common.FieldDefinition;
import com.dell.doradus.common.TableDefinition;
import com.dell.doradus.olap.builder.IdsBuilder;
import com.dell.doradus.olap.builder.LinkFieldBuilder;
import com.dell.doradus.olap.builder.NumsBuilder;
import com.dell.doradus.olap.builder.TextFieldBuilder;
import com.dell.doradus.olap.builder.ValuesBuilder;
import com.dell.doradus.olap.io.BSTR;
import com.dell.doradus.olap.io.VDirectory;
import com.dell.doradus.olap.store.FieldWriter;
import com.dell.doradus.olap.store.FieldWriterSV;
import com.dell.doradus.olap.store.IdWriter;
import com.dell.doradus.olap.store.InverseLinkWriter;
import com.dell.doradus.olap.store.NumWriter;
import com.dell.doradus.olap.store.NumWriterMV;
import com.dell.doradus.olap.store.SegmentStats;
import com.dell.doradus.olap.store.ValueWriter;
import java.util.HashMap;
import java.util.Map;

public class TableBuilder {
    private IdsBuilder m_ids = new IdsBuilder();
    private Map<String, NumsBuilder> m_nums = new HashMap<String, NumsBuilder>();
    private Map<String, ValuesBuilder> m_values = new HashMap<String, ValuesBuilder>();
    private Map<String, TextFieldBuilder> m_fields = new HashMap<String, TextFieldBuilder>();
    private Map<String, LinkFieldBuilder> m_links = new HashMap<String, LinkFieldBuilder>();

    public TableBuilder() {
        this.m_ids = new IdsBuilder();
    }

    public IdsBuilder getIds() {
        return this.m_ids;
    }

    public int addDoc(BSTR id) {
        return this.m_ids.add(id);
    }

    public void setDeleted(int doc) {
        this.m_ids.setDeleted(doc, true);
    }

    public void addNum(int doc, String field, long value) {
        NumsBuilder b = this.m_nums.get(field);
        if (b == null) {
            b = new NumsBuilder(this.m_ids);
            this.m_nums.put(field, b);
        }
        b.add(doc, value);
    }

    public void addTerm(int doc, String field, BSTR term, BSTR orig) {
        ValuesBuilder b = this.m_values.get(field);
        if (b == null) {
            b = new ValuesBuilder();
            this.m_values.put(field, b);
        }
        int fld = b.addTerm(term, orig);
        TextFieldBuilder t = this.m_fields.get(field);
        if (t == null) {
            t = new TextFieldBuilder(this.m_ids, b);
            this.m_fields.put(field, t);
        }
        t.add(doc, fld);
    }

    public void addLink(int doc, String field, IdsBuilder linked, int linkedDoc) {
        LinkFieldBuilder b = this.m_links.get(field);
        if (b == null) {
            b = new LinkFieldBuilder(this.m_ids, linked);
            this.m_links.put(field, b);
        }
        b.add(doc, linkedDoc);
    }

    public void flush(VDirectory dir, SegmentStats stats, TableDefinition tableDef) {
        FieldDefinition fieldDef;
        String table = tableDef.getTableName();
        IdWriter id_writer = new IdWriter(dir, table);
        this.m_ids.flush(id_writer);
        id_writer.close();
        int docs_count = id_writer.size();
        stats.addTable(table, docs_count);
        for (String field : this.m_nums.keySet()) {
            Object num_writer;
            fieldDef = tableDef.getFieldDef(field);
            if (fieldDef.isCollection()) {
                num_writer = new NumWriterMV(docs_count);
                this.m_nums.get(field).flush((NumWriterMV)num_writer);
                ((NumWriterMV)num_writer).close(dir, table, field);
                stats.addNumField(fieldDef, (NumWriterMV)num_writer);
                continue;
            }
            num_writer = new NumWriter(docs_count);
            this.m_nums.get(field).flush((NumWriter)num_writer);
            ((NumWriter)num_writer).close(dir, table, field);
            stats.addNumField(fieldDef, (NumWriter)num_writer);
        }
        for (String field : this.m_values.keySet()) {
            ValueWriter term_writer = new ValueWriter(dir, table, field);
            this.m_values.get(field).flush(term_writer);
            term_writer.close();
        }
        for (String field : this.m_fields.keySet()) {
            Object field_writer;
            fieldDef = tableDef.getFieldDef(field);
            if (fieldDef.isCollection()) {
                field_writer = new FieldWriter(docs_count);
                this.m_fields.get(field).flush((FieldWriter)field_writer);
                ((FieldWriter)field_writer).close(dir, table, field);
                stats.addTextField(fieldDef, (FieldWriter)field_writer);
                continue;
            }
            field_writer = new FieldWriterSV(docs_count);
            this.m_fields.get(field).flush((FieldWriterSV)field_writer);
            ((FieldWriterSV)field_writer).close(dir, table, field);
            stats.addTextField(fieldDef, (FieldWriterSV)field_writer);
        }
    }

    public void flushLinks(VDirectory dir, SegmentStats stats, TableDefinition tableDef) {
        String table = tableDef.getTableName();
        int docs_count = stats.getTable((String)table).documents;
        for (String field : this.m_links.keySet()) {
            FieldDefinition fieldDef = tableDef.getFieldDef(field);
            if (InverseLinkWriter.shouldWriteInverse(fieldDef)) {
                InverseLinkWriter.writeInverse(dir, fieldDef, stats);
                continue;
            }
            FieldWriter field_writer = new FieldWriter(docs_count);
            this.m_links.get(field).flush(field_writer);
            field_writer.close(dir, table, field);
            stats.addLinkField(fieldDef, field_writer);
        }
    }
}

