/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.builder;

import com.dell.doradus.common.ApplicationDefinition;
import com.dell.doradus.common.DBObject;
import com.dell.doradus.common.DBObjectBatch;
import com.dell.doradus.common.FieldDefinition;
import com.dell.doradus.common.TableDefinition;
import com.dell.doradus.common.Utils;
import com.dell.doradus.core.IDGenerator;
import com.dell.doradus.olap.OlapBatch;
import com.dell.doradus.olap.OlapDocument;
import com.dell.doradus.olap.builder.TableBuilder;
import com.dell.doradus.olap.io.BSTR;
import com.dell.doradus.olap.io.VDirectory;
import com.dell.doradus.olap.store.SegmentStats;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class SegmentBuilder {
    private ApplicationDefinition m_appDef;
    private Map<String, TableBuilder> m_tables = new HashMap<String, TableBuilder>();

    public SegmentBuilder(ApplicationDefinition application) {
        this.m_appDef = application;
    }

    public void add(OlapBatch batch) {
        for (OlapDocument doc : batch) {
            this.add(doc);
        }
    }

    public void add(DBObjectBatch batch) {
        for (DBObject doc : batch.getObjects()) {
            this.add(doc);
        }
    }

    public void flush(VDirectory dir) {
        TableBuilder b;
        SegmentStats stats = new SegmentStats();
        for (String table : this.m_tables.keySet()) {
            b = this.m_tables.get(table);
            b.flush(dir, stats, this.m_appDef.getTableDef(table));
        }
        for (String table : this.m_tables.keySet()) {
            b = this.m_tables.get(table);
            b.flushLinks(dir, stats, this.m_appDef.getTableDef(table));
        }
        stats.totalStoreSize = dir.totalLength(false);
        stats.save(dir);
    }

    private TableBuilder getTable(TableDefinition tableDef) {
        TableBuilder b = this.m_tables.get(tableDef.getTableName());
        if (b == null) {
            b = new TableBuilder();
            this.m_tables.put(tableDef.getTableName(), b);
        }
        return b;
    }

    private void add(OlapDocument document) {
        String table = document.getTable();
        TableDefinition tableDef = this.m_appDef.getTableDef(table);
        Utils.require((tableDef != null ? 1 : 0) != 0, (String)("Table '" + table + "' does not exist"));
        TableBuilder b = this.getTable(tableDef);
        int doc = b.addDoc(document.getIdBinary());
        if (document.isDeleted()) {
            b.setDeleted(doc);
        }
        int fields = document.getFieldsCount();
        int i = 0;
        while (i < fields) {
            String field = document.getFieldName(i);
            FieldDefinition fieldDef = tableDef.getFieldDef(field);
            Utils.require((fieldDef != null ? 1 : 0) != 0, (String)("Field '" + field + "' does not exist"));
            switch (fieldDef.getType()) {
                case BOOLEAN: 
                case INTEGER: 
                case LONG: 
                case TIMESTAMP: 
                case FLOAT: 
                case DOUBLE: {
                    b.addNum(doc, field, this.parseNumField(fieldDef, document.getFieldValue(i)));
                    break;
                }
                case LINK: {
                    TableBuilder b2 = this.getTable(fieldDef.getInverseTableDef());
                    int linkedDoc = b2.addDoc(document.getFieldValueBinary(i));
                    b.addLink(doc, field, b2.getIds(), linkedDoc);
                    b2.addLink(linkedDoc, fieldDef.getLinkInverse(), b.getIds(), doc);
                    break;
                }
                case TEXT: {
                    BSTR orig = document.getFieldValueBinary(i);
                    BSTR term = document.getFieldValueBinaryLowercase(i);
                    b.addTerm(doc, field, term, orig);
                    break;
                }
                case BINARY: {
                    b.addTerm(doc, field, document.getFieldValueBinary(i), document.getFieldValueBinary(i));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown Olap type " + fieldDef.getType().toString());
                }
            }
            ++i;
        }
    }

    private void add(DBObject document) {
        TableDefinition tableDef;
        String table = document.getTableName();
        String id = document.getObjectID();
        if (id == null) {
            id = Utils.base64FromBinary((byte[])IDGenerator.nextID());
        }
        Utils.require(((tableDef = this.m_appDef.getTableDef(table)) != null ? 1 : 0) != 0, (String)("Table '" + table + "' does not exist"));
        TableBuilder b = this.getTable(tableDef);
        int doc = b.addDoc(new BSTR(id));
        if (document.isDeleted()) {
            b.setDeleted(doc);
        }
        for (String field : document.getFieldNames()) {
            FieldDefinition fieldDef = tableDef.getFieldDef(field);
            if (fieldDef == null) continue;
            List values = document.getFieldValues(field);
            for (String value : values) {
                switch (fieldDef.getType()) {
                    case BOOLEAN: 
                    case INTEGER: 
                    case LONG: 
                    case TIMESTAMP: 
                    case FLOAT: 
                    case DOUBLE: {
                        b.addNum(doc, field, this.parseNumField(fieldDef, value));
                        break;
                    }
                    case LINK: {
                        TableBuilder b2 = this.getTable(fieldDef.getInverseTableDef());
                        int linkedDoc = b2.addDoc(new BSTR(value));
                        b.addLink(doc, field, b2.getIds(), linkedDoc);
                        b2.addLink(linkedDoc, fieldDef.getLinkInverse(), b.getIds(), doc);
                        break;
                    }
                    case TEXT: {
                        BSTR orig = new BSTR(value);
                        BSTR term = new BSTR(value.toLowerCase(Locale.ROOT));
                        b.addTerm(doc, field, term, orig);
                        break;
                    }
                    case BINARY: {
                        BSTR term = new BSTR(value);
                        b.addTerm(doc, field, term, term);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown Olap type " + fieldDef.getType().toString());
                    }
                }
            }
        }
    }

    private long parseNumField(FieldDefinition fieldDef, String value) {
        try {
            switch (fieldDef.getType()) {
                case BOOLEAN: {
                    return "true".equalsIgnoreCase(value) ? 1 : 0;
                }
                case INTEGER: {
                    return Integer.parseInt(value);
                }
                case LONG: {
                    return Long.parseLong(value);
                }
                case DOUBLE: {
                    double val = Double.parseDouble(value);
                    long lval = Double.doubleToRawLongBits(val);
                    return lval;
                }
                case FLOAT: {
                    float val = Float.parseFloat(value);
                    int ival = Float.floatToRawIntBits(val);
                    return ival;
                }
                case TIMESTAMP: {
                    Date dvalue = Utils.dateFromString((String)value);
                    return dvalue.getTime();
                }
            }
            throw new IllegalArgumentException("Not a numeric type " + fieldDef.getType().toString());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid format for field '" + fieldDef.getName() + "': " + value, e);
        }
    }
}

