/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.builder;

import com.dell.doradus.olap.builder.IdsBuilder;
import com.dell.doradus.olap.store.IntList;
import com.dell.doradus.olap.store.LongList;
import com.dell.doradus.olap.store.NumWriter;
import com.dell.doradus.olap.store.NumWriterMV;
import java.util.Arrays;

public class NumsBuilder {
    private IdsBuilder m_ids;
    private IntList m_docs;
    private LongList m_values;

    public NumsBuilder(IdsBuilder ids) {
        this.m_ids = ids;
        this.m_docs = new IntList(64);
        this.m_values = new LongList(64);
    }

    public void add(int doc, long value) {
        this.m_docs.add(doc);
        this.m_values.add(value);
    }

    public int size() {
        return this.m_docs.size();
    }

    public void flush(NumWriter writer) {
        int i = 0;
        while (i < this.size()) {
            int id = this.m_docs.get(i);
            int doc = this.m_ids.doc(id);
            long val = this.m_values.get(i);
            writer.add(doc, val);
            ++i;
        }
    }

    public void flush(NumWriterMV writer) {
        int doc;
        int docs = writer.getDocsCount();
        long[] values = new long[this.size()];
        int[] offsets = new int[docs + 1];
        int i = 0;
        while (i < this.size()) {
            doc = this.m_ids.doc(this.m_docs.get(i));
            int n = doc + 1;
            offsets[n] = offsets[n] + 1;
            ++i;
        }
        i = 0;
        while (i < docs) {
            int n = i + 1;
            offsets[n] = offsets[n] + offsets[i];
            ++i;
        }
        i = 0;
        while (i < this.size()) {
            doc = this.m_ids.doc(this.m_docs.get(i));
            values[offsets[doc]] = this.m_values.get(i);
            int n = doc;
            offsets[n] = offsets[n] + 1;
            ++i;
        }
        i = 0;
        while (i < docs) {
            int offset = i == 0 ? 0 : offsets[i - 1];
            int length = i == 0 ? offsets[0] : offsets[i] - offsets[i - 1];
            Arrays.sort(values, offset, offset + length);
            int j = 0;
            while (j < length) {
                writer.add(i, values[offset + j]);
                ++j;
            }
            ++i;
        }
    }
}

