/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.builder;

import com.dell.doradus.olap.builder.IdsBuilder;
import com.dell.doradus.olap.store.FieldWriter;
import com.dell.doradus.olap.store.IntList;
import java.util.Arrays;

public class LinkFieldBuilder {
    private IdsBuilder m_ids;
    private IdsBuilder m_links;
    private IntList m_docs;
    private IntList m_values;

    public LinkFieldBuilder(IdsBuilder ids, IdsBuilder links) {
        this.m_ids = ids;
        this.m_links = links;
        this.m_docs = new IntList(64);
        this.m_values = new IntList(64);
    }

    public void add(int doc, int val) {
        this.m_docs.add(doc);
        this.m_values.add(val);
    }

    public int size() {
        return this.m_docs.size();
    }

    public void flush(FieldWriter writer) {
        int doc;
        int docs = writer.getDocsCount();
        int[] values = new int[this.size()];
        int[] offsets = new int[docs + 1];
        int i = 0;
        while (i < this.size()) {
            doc = this.m_ids.doc(this.m_docs.get(i));
            int n = doc + 1;
            offsets[n] = offsets[n] + 1;
            ++i;
        }
        i = 0;
        while (i < docs) {
            int n = i + 1;
            offsets[n] = offsets[n] + offsets[i];
            ++i;
        }
        i = 0;
        while (i < this.size()) {
            int linkeddoc;
            doc = this.m_ids.doc(this.m_docs.get(i));
            values[offsets[doc]] = linkeddoc = this.m_links.doc(this.m_values.get(i));
            int n = doc;
            offsets[n] = offsets[n] + 1;
            ++i;
        }
        i = 0;
        while (i < docs) {
            int offset = i == 0 ? 0 : offsets[i - 1];
            int length = i == 0 ? offsets[0] : offsets[i] - offsets[i - 1];
            Arrays.sort(values, offset, offset + length);
            int j = 0;
            while (j < length) {
                writer.add(i, values[offset + j]);
                ++j;
            }
            ++i;
        }
    }
}

