/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.builder;

import com.dell.doradus.olap.collections.strings.BstrSet;
import com.dell.doradus.olap.io.BSTR;
import com.dell.doradus.olap.store.BitVector;
import com.dell.doradus.olap.store.IdWriter;
import com.dell.doradus.olap.store.IntList;

public class IdsBuilder {
    private BstrSet m_ids = new BstrSet();
    private IntList m_deleted = new IntList();
    private int[] m_remap;
    private int[] m_id_to_doc;
    private boolean m_hasDeletions;

    public int add(BSTR id) {
        int index = this.m_ids.add(id);
        if (index == this.m_deleted.size()) {
            this.m_deleted.add(0);
        }
        return index;
    }

    public void setDeleted(int doc, boolean deleted) {
        this.m_deleted.set(doc, deleted ? 1 : 0);
        if (deleted) {
            this.m_hasDeletions = true;
        }
    }

    public int size() {
        return this.m_ids.size();
    }

    public int id(int index) {
        return this.m_remap[index];
    }

    public int doc(int id) {
        return this.m_id_to_doc[id];
    }

    public void flush(IdWriter writer) {
        this.m_remap = this.m_ids.sort();
        this.m_id_to_doc = new int[this.m_remap.length];
        int i = 0;
        while (i < this.m_id_to_doc.length) {
            int id = this.m_remap[i];
            this.m_id_to_doc[id] = writer.add(this.m_ids.get(id));
            ++i;
        }
        if (this.m_hasDeletions) {
            BitVector v = new BitVector(this.size());
            int i2 = 0;
            while (i2 < this.size()) {
                if (this.m_deleted.get(i2) == 1) {
                    v.set(this.m_id_to_doc[i2]);
                }
                ++i2;
            }
            writer.setDeletedVector(v);
        }
    }
}

