/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.builder;

import com.dell.doradus.common.JSONAnnie;
import com.dell.doradus.common.UNode;
import com.dell.doradus.common.Utils;
import com.dell.doradus.olap.OlapBatch;
import com.dell.doradus.olap.OlapDocument;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BatchBuilder {
    public static OlapBatch parseJSON(String text) {
        Listener listener = new Listener();
        new JSONAnnie(text).parse((JSONAnnie.SajListener)listener);
        return listener.result;
    }

    public static OlapBatch parseJSON(Reader reader) {
        Listener listener = new Listener();
        new JSONAnnie(reader).parse((JSONAnnie.SajListener)listener);
        return listener.result;
    }

    public static OlapBatch fromUNode(UNode rootNode) {
        Utils.require((boolean)rootNode.getName().equals("batch"), (String)("Root node must be 'batch': " + rootNode.getName()));
        OlapBatch batch = new OlapBatch();
        UNode docsNode = rootNode.getMember("docs");
        Utils.require((docsNode != null ? 1 : 0) != 0, (String)"'batch' node requires child 'docs' node");
        for (UNode docNode : docsNode.getMemberList()) {
            Utils.require((boolean)docNode.getName().equals("doc"), (String)("'doc' node expected: " + docNode.getName()));
            OlapDocument document = batch.addDoc();
            for (UNode fieldNode : docNode.getMemberList()) {
                BatchBuilder.addFieldValues(document, fieldNode);
            }
            Utils.require((document.getTable() != null ? 1 : 0) != 0, (String)"'doc' node missing '_table' value");
        }
        return batch;
    }

    private static void addFieldValues(OlapDocument document, UNode fieldNode) {
        String fieldName = fieldNode.getName();
        Utils.require((fieldName != null ? 1 : 0) != 0, (String)("'field' node missing 'name' value:" + fieldNode.getName()));
        if (fieldNode.isValue()) {
            BatchBuilder.addFieldValue(document, fieldName, fieldNode.getValue());
        } else if (fieldNode.isArray()) {
            for (UNode valueNode : fieldNode.getMemberList()) {
                Utils.require((boolean)valueNode.isValue(), (String)("Value expected: " + valueNode));
                BatchBuilder.addFieldValue(document, fieldName, valueNode.getValue());
            }
        } else {
            for (UNode childNode : fieldNode.getMemberList()) {
                if (childNode.getName().equals("add") && !childNode.isValue()) {
                    for (UNode valueNode : childNode.getMemberList()) {
                        Utils.require((boolean)valueNode.isValue(), (String)("Value expected: " + valueNode));
                        BatchBuilder.addFieldValue(document, fieldName, valueNode.getValue());
                    }
                    continue;
                }
                BatchBuilder.addFieldValues(document, childNode);
            }
        }
    }

    private static void addFieldValue(OlapDocument document, String fieldName, String value) {
        if (fieldName.equals("_ID")) {
            document.setId(value);
        } else if (fieldName.equals("_table")) {
            document.setTable(value);
        } else if (fieldName.equals("_deleted")) {
            document.setDeleted("true".equals(value));
        } else {
            document.addField(fieldName, value);
        }
    }

    static class Listener
    implements JSONAnnie.SajListener {
        OlapBatch result = new OlapBatch();
        Map<String, List<String>> valueMap = new HashMap<String, List<String>>();
        List<String> fieldStack = new ArrayList<String>();
        Set<String> values = new HashSet<String>();
        StringBuilder buffer = new StringBuilder();
        int level = 0;

        Listener() {
        }

        public void onStartObject(String name) {
            switch (this.level) {
                case 0: {
                    Utils.require((boolean)name.equals("batch"), (String)("Root node must be 'batch': " + name));
                    break;
                }
                case 1: {
                    Utils.require((boolean)name.equals("docs"), (String)("'docs' array expected: " + name));
                    break;
                }
                case 2: {
                    Utils.require((boolean)name.equals("doc"), (String)("'doc' object expected: " + name));
                    this.valueMap.clear();
                    this.fieldStack.clear();
                    break;
                }
                default: {
                    this.fieldStack.add(name);
                }
            }
            ++this.level;
        }

        public void onEndObject() {
            if (this.fieldStack.size() > 0) {
                this.fieldStack.remove(this.fieldStack.size() - 1);
            }
            if (--this.level == 2) {
                this.buildObject();
            }
        }

        public void onStartArray(String name) {
            switch (this.level) {
                case 0: 
                case 2: {
                    Utils.require((boolean)false, (String)("Unexpected array start: " + name));
                }
                case 1: {
                    Utils.require((boolean)name.equals("docs"), (String)("'docs' array expected: " + name));
                    break;
                }
                default: {
                    this.fieldStack.add(name);
                }
            }
            ++this.level;
        }

        public void onEndArray() {
            if (this.fieldStack.size() > 0) {
                this.fieldStack.remove(this.fieldStack.size() - 1);
            }
            --this.level;
        }

        public void onValue(String name, String value) {
            Utils.require((this.level >= 3 ? 1 : 0) != 0, (String)"Unexpected recognized element: %s", (Object[])new Object[]{name});
            this.saveValue(name, value);
        }

        private void saveValue(String name, String value) {
            String dottedName = this.getDottedName(name);
            List<String> values = this.valueMap.get(dottedName);
            if (values == null) {
                values = new ArrayList<String>(1);
                this.valueMap.put(dottedName, values);
            }
            values.add(value);
        }

        private String getDottedName(String name) {
            this.buffer.setLength(0);
            for (String parentName : this.fieldStack) {
                this.buffer.append(parentName);
                this.buffer.append(".");
            }
            this.buffer.append(name);
            return this.buffer.toString();
        }

        private void buildObject() {
            OlapDocument document = this.result.addDoc();
            for (String dottedName : this.valueMap.keySet()) {
                List<String> values = this.valueMap.get(dottedName);
                String[] names = dottedName.split("\\.");
                this.addValue(document, names, 0, values);
            }
        }

        private void addValue(OlapDocument document, String[] names, int inx, List<String> values) {
            String fieldName = names[inx];
            if (names.length - inx == 2 && names[inx + 1].equals("value")) {
                this.addValues(document, fieldName, values);
            } else if (names.length - inx == 3 && names[inx + 2].equals("value") && names[inx + 1].equals("add")) {
                this.addValues(document, fieldName, values);
            } else if (names.length - inx > 1) {
                this.addValue(document, names, inx + 1, values);
            } else {
                this.addValues(document, fieldName, values);
            }
        }

        private void addValues(OlapDocument document, String fieldName, Iterable<String> values) {
            for (String value : values) {
                this.addValue(document, fieldName, value);
            }
        }

        private void addValue(OlapDocument document, String fieldName, String value) {
            if (Utils.isEmpty((String)value)) {
                return;
            }
            if (fieldName.equals("_ID")) {
                document.setId(value);
            } else if (fieldName.equals("_table")) {
                document.setTable(value);
            } else if (fieldName.equals("_deleted")) {
                document.setDeleted("true".equals(value));
            } else {
                document.addField(fieldName, value);
            }
        }
    }
}

