/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.aggregate.mr;

import com.dell.doradus.olap.aggregate.mr.MFCollector;
import com.dell.doradus.olap.collections.BdLongSet;
import com.dell.doradus.olap.store.CubeSearcher;
import com.dell.doradus.search.aggregate.AggregationGroup;
import com.dell.doradus.search.aggregate.AggregationGroupItem;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MFCollectorSet {
    private static Logger LOG = LoggerFactory.getLogger((String)"MFCollectorSet");
    public MFCollector[] collectors;
    public MFCollector commonPartCollector;

    public MFCollectorSet(CubeSearcher searcher, List<AggregationGroup> groups, boolean allowCommonPart) {
        int commonIndex = 0;
        if (allowCommonPart) {
            commonIndex = this.getCommonPart(groups);
        }
        if (commonIndex > 0) {
            this.commonPartCollector = MFCollector.create(searcher, groups.get(0), 0, commonIndex);
        }
        this.collectors = new MFCollector[groups.size()];
        int i = 0;
        while (i < this.collectors.length) {
            this.collectors[i] = MFCollector.create(searcher, groups.get(i), commonIndex, groups.get((int)i).items.size());
            ++i;
        }
    }

    public int size() {
        return this.collectors.length;
    }

    public void collect(long doc, BdLongSet[] values) {
        int i = 0;
        while (i < this.collectors.length) {
            this.collectors[i].collect(doc, values[i]);
            ++i;
        }
    }

    private int getCommonPart(List<AggregationGroup> groups) {
        if (groups.size() < 2) {
            return 0;
        }
        int i = 0;
        while (i < groups.size()) {
            if (groups.get((int)i).filter != null) {
                return 0;
            }
            ++i;
        }
        int itemsCount = groups.get((int)0).items.size() - 1;
        int i2 = 1;
        while (i2 < groups.size()) {
            itemsCount = Math.min(itemsCount, groups.get((int)i2).items.size() - 1);
            ++i2;
        }
        if (itemsCount <= 0) {
            return 0;
        }
        int itemIndex = 0;
        while (itemIndex < itemsCount) {
            boolean eq = true;
            AggregationGroupItem item = groups.get((int)0).items.get(itemIndex);
            if (item.xlinkContext != null) break;
            int i3 = 1;
            while (i3 < groups.size()) {
                AggregationGroupItem item2 = groups.get((int)i3).items.get(itemIndex);
                if (!item.equals(item2) || item.xlinkContext != null) {
                    eq = false;
                    break;
                }
                ++i3;
            }
            if (!eq) break;
            ++itemIndex;
        }
        if (itemIndex > 0) {
            LOG.info("Found common path for groups: " + itemIndex);
        }
        return itemIndex;
    }
}

