/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.aggregate.mr;

import com.dell.doradus.common.FieldDefinition;
import com.dell.doradus.common.FieldType;
import com.dell.doradus.common.TableDefinition;
import com.dell.doradus.common.Utils;
import com.dell.doradus.olap.XType;
import com.dell.doradus.olap.aggregate.mr.MGName;
import com.dell.doradus.olap.collections.BdLongSet;
import com.dell.doradus.olap.io.BSTR;
import com.dell.doradus.olap.search.Result;
import com.dell.doradus.olap.search.ResultBuilder;
import com.dell.doradus.olap.store.CubeSearcher;
import com.dell.doradus.olap.store.FieldSearcher;
import com.dell.doradus.olap.store.IdSearcher;
import com.dell.doradus.olap.store.IntIterator;
import com.dell.doradus.olap.store.NumSearcherMV;
import com.dell.doradus.olap.store.ValueSearcher;
import com.dell.doradus.olap.xlink.DirectXLinkCollector;
import com.dell.doradus.olap.xlink.InverseXLinkCollector;
import com.dell.doradus.olap.xlink.XGroups;
import com.dell.doradus.search.aggregate.AggregationGroup;
import com.dell.doradus.search.aggregate.AggregationGroupItem;
import com.dell.doradus.search.query.Query;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;

public abstract class MFCollector {
    public CubeSearcher searcher;

    public MFCollector(CubeSearcher searcher) {
        this.searcher = searcher;
    }

    public void collectEmptyGroups(BdLongSet values) {
    }

    public abstract void collect(long var1, BdLongSet var3);

    public abstract MGName getField(long var1);

    public abstract boolean requiresOrdering();

    public static MFCollector create(CubeSearcher searcher, AggregationGroup group) {
        return MFCollector.create(searcher, group, 0, group.items.size());
    }

    public static MFCollector create(CubeSearcher searcher, AggregationGroup group, int start, int end) {
        if (group.batchexAliases != null) {
            return new BatchexCollector(searcher, group.tableDef, group.batchexAliases, group.batchexFilters);
        }
        AggregationGroupItem last = group.items.get(end - 1);
        FieldDefinition fieldDef = last.fieldDef;
        MFCollector collector = null;
        if (NumSearcherMV.isNumericType(fieldDef.getType())) {
            collector = new EndNumField(searcher, fieldDef, group);
        } else if (fieldDef.isLinkField()) {
            Result filter = null;
            if (last.query != null) {
                filter = ResultBuilder.search(last.tableDef, last.query, searcher);
            }
            collector = new IdField(searcher, fieldDef.getInverseTableDef());
            collector = last.isTransitive ? new TransitiveLinkField(searcher, fieldDef, last.transitiveDepth, filter, collector) : new LinkField(searcher, fieldDef, filter, collector);
        } else if (last.fieldDef.isXLinkDirect()) {
            collector = new DirectXLinkCollector(searcher, last.fieldDef, (XGroups)last.xlinkContext);
        } else if (fieldDef.isXLinkInverse()) {
            collector = new InverseXLinkCollector(searcher, fieldDef, (XGroups)last.xlinkContext);
        } else if (fieldDef.getType() == FieldType.TEXT) {
            collector = new EndTextField(searcher, fieldDef);
        } else if (last.isID) {
            collector = new IdField(searcher, last.tableDef);
        } else {
            throw new IllegalArgumentException("Invalid field in aggregation group: " + last.name);
        }
        int i = end - 2;
        while (i >= start) {
            AggregationGroupItem item = group.items.get(i);
            Result filter = null;
            if (item.query != null) {
                filter = ResultBuilder.search(item.tableDef, item.query, searcher);
            }
            if (item.fieldDef.isXLinkDirect()) {
                collector = new DirectXLinkCollector(searcher, item.fieldDef, (XGroups)item.xlinkContext);
            } else if (item.fieldDef.isXLinkInverse()) {
                collector = new InverseXLinkCollector(searcher, item.fieldDef, (XGroups)item.xlinkContext);
            } else if (item.fieldDef.isLinkField()) {
                collector = item.isTransitive ? new TransitiveLinkField(searcher, item.fieldDef, item.transitiveDepth, filter, collector) : new LinkField(searcher, item.fieldDef, filter, collector);
            } else {
                throw new IllegalArgumentException("Invalid field in aggregation group: " + item.name);
            }
            --i;
        }
        if (group.filter != null) {
            Result filter = ResultBuilder.search(group.tableDef, group.filter, searcher);
            collector = new FilteredCollector(filter, collector);
        }
        return collector;
    }

    public static class BatchexCollector
    extends MFCollector {
        private String[] m_aliases;
        private Result[] m_filters;

        public BatchexCollector(CubeSearcher searcher, TableDefinition tableDef, List<String> aliases, List<Query> queries) {
            super(searcher);
            this.m_aliases = new String[queries.size()];
            this.m_filters = new Result[queries.size()];
            int i = 0;
            while (i < queries.size()) {
                this.m_aliases[i] = aliases.get(i);
                this.m_filters[i] = ResultBuilder.search(tableDef, queries.get(i), searcher);
                ++i;
            }
        }

        @Override
        public void collect(long doc, BdLongSet values) {
            int i = 0;
            while (i < this.m_aliases.length) {
                if (this.m_filters[i].get((int)doc)) {
                    values.add(i);
                }
                ++i;
            }
        }

        @Override
        public MGName getField(long value) {
            return new MGName(this.m_aliases[(int)value], new BSTR(value));
        }

        @Override
        public void collectEmptyGroups(BdLongSet values) {
            long l = 0L;
            while (l < (long)this.m_aliases.length) {
                values.add(l);
                ++l;
            }
        }

        @Override
        public boolean requiresOrdering() {
            return false;
        }
    }

    public static class BooleanField
    extends MFCollector {
        public BooleanField(CubeSearcher searcher) {
            super(searcher);
        }

        @Override
        public void collect(long doc, BdLongSet values) {
            values.add(doc);
        }

        @Override
        public MGName getField(long value) {
            return new MGName(value == 0L ? "false" : "true", new BSTR(value == 0L ? "0" : "1"));
        }

        @Override
        public boolean requiresOrdering() {
            return false;
        }
    }

    public class DateField
    extends MFCollector {
        private String m_truncate;
        private TimeZone m_zone;
        private long m_divisor;
        private GregorianCalendar m_Calendar;

        public DateField(CubeSearcher searcher, String truncate, String timeZone) {
            super(searcher);
            this.m_zone = timeZone != null ? TimeZone.getTimeZone(timeZone) : Utils.UTC_TIMEZONE;
            this.m_truncate = truncate;
            if (this.m_truncate == null) {
                this.m_truncate = "SECOND";
            }
            this.m_truncate = this.m_truncate.toUpperCase();
            this.m_divisor = "SECOND".equals(this.m_truncate) ? 1000L : ("MINUTE".equals(this.m_truncate) ? 60000L : ("HOUR".equals(this.m_truncate) ? 3600000L : 3600000L));
            this.m_Calendar = (GregorianCalendar)GregorianCalendar.getInstance(this.m_zone);
        }

        @Override
        public void collect(long doc, BdLongSet values) {
            values.add(doc / this.m_divisor);
        }

        @Override
        public boolean requiresOrdering() {
            return false;
        }

        @Override
        public MGName getField(long value) {
            this.m_Calendar.setTimeInMillis(value * this.m_divisor);
            if ("SECOND".equals(this.m_truncate) || "MINUTE".equals(this.m_truncate) || "HOUR".equals(this.m_truncate)) {
                return new MGName(Utils.formatDate((Calendar)this.m_Calendar, (int)13));
            }
            if ("DAY".equals(this.m_truncate)) {
                return new MGName(Utils.formatDate((Calendar)this.m_Calendar, (int)5));
            }
            if ("WEEK".equals(this.m_truncate)) {
                GregorianCalendar calendar = Utils.truncateToWeek((GregorianCalendar)this.m_Calendar);
                return new MGName(Utils.formatDate((Calendar)calendar, (int)5));
            }
            if ("MONTH".equals(this.m_truncate)) {
                this.m_Calendar.set(5, 1);
                return new MGName(Utils.formatDate((Calendar)this.m_Calendar, (int)5));
            }
            if ("QUARTER".equals(this.m_truncate)) {
                this.m_Calendar.set(5, 1);
                this.m_Calendar.set(2, this.m_Calendar.get(2) / 3 * 3);
                return new MGName(Utils.formatDate((Calendar)this.m_Calendar, (int)5));
            }
            if ("YEAR".equals(this.m_truncate)) {
                return new MGName(Utils.formatDate((Calendar)this.m_Calendar, (int)1));
            }
            throw new IllegalArgumentException("Unknown truncate function: " + this.m_truncate);
        }
    }

    public class DateSubField
    extends MFCollector {
        private AggregationGroup.SubField m_subfield;
        private Calendar m_calendar;
        private int m_calendarField;
        private String[] m_months;

        public DateSubField(CubeSearcher searcher, AggregationGroup.SubField subfield) {
            super(searcher);
            this.m_months = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
            this.m_subfield = subfield;
            this.m_calendar = new GregorianCalendar(Utils.UTC_TIMEZONE);
            switch (subfield) {
                case MINUTE: {
                    this.m_calendarField = 12;
                    break;
                }
                case HOUR: {
                    this.m_calendarField = 11;
                    break;
                }
                case DAY: {
                    this.m_calendarField = 5;
                    break;
                }
                case MONTH: {
                    this.m_calendarField = 2;
                    break;
                }
                case YEAR: {
                    this.m_calendarField = 1;
                    break;
                }
                default: {
                    Utils.require((boolean)false, (String)("Undefined subfield: " + (Object)((Object)subfield)));
                }
            }
        }

        @Override
        public void collect(long doc, BdLongSet values) {
            this.m_calendar.setTimeInMillis(doc);
            int pos = this.m_calendar.get(this.m_calendarField);
            values.add(pos);
        }

        @Override
        public MGName getField(long value) {
            if (this.m_subfield == AggregationGroup.SubField.MONTH) {
                return new MGName(this.m_months[(int)value], new BSTR(value));
            }
            return new MGName(value);
        }

        @Override
        public boolean requiresOrdering() {
            return false;
        }
    }

    public static class DoubleField
    extends MFCollector {
        public DoubleField(CubeSearcher searcher) {
            super(searcher);
        }

        @Override
        public void collect(long doc, BdLongSet values) {
            if (doc < 0L) {
                doc = -(doc & Long.MAX_VALUE);
            }
            values.add(doc);
        }

        @Override
        public MGName getField(long value) {
            if (value < 0L) {
                value = -value | Long.MIN_VALUE;
            }
            double dval = Double.longBitsToDouble(value);
            return new MGName(XType.toString(dval), new BSTR(dval));
        }

        @Override
        public boolean requiresOrdering() {
            return false;
        }
    }

    public static class EndNumField
    extends MFCollector {
        private NumSearcherMV m_numSearcher;
        private MFCollector m_collector;

        public EndNumField(CubeSearcher searcher, FieldDefinition fieldDef, AggregationGroup group) {
            super(searcher);
            this.m_numSearcher = searcher.getNumSearcher(fieldDef.getTableName(), fieldDef.getName());
            switch (fieldDef.getType()) {
                case BOOLEAN: {
                    this.m_collector = new BooleanField(searcher);
                    break;
                }
                case INTEGER: 
                case LONG: {
                    if (group.batch != null) {
                        this.m_collector = new NumBatchField(searcher, group.batch);
                        break;
                    }
                    this.m_collector = new LongField(searcher);
                    break;
                }
                case FLOAT: {
                    if (group.batch != null) {
                        this.m_collector = new NumFloatBatchField(searcher, group.batch);
                        break;
                    }
                    this.m_collector = new FloatField(searcher);
                    break;
                }
                case DOUBLE: {
                    if (group.batch != null) {
                        this.m_collector = new NumDoubleBatchField(searcher, group.batch);
                        break;
                    }
                    this.m_collector = new DoubleField(searcher);
                    break;
                }
                case TIMESTAMP: {
                    if (group.subField != null) {
                        this.m_collector = new DateSubField(searcher, group.subField);
                        break;
                    }
                    this.m_collector = new DateField(searcher, group.truncate, group.timeZone);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported type: " + fieldDef.getType().toString());
                }
            }
        }

        @Override
        public void collect(long doc, BdLongSet values) {
            int fcount = this.m_numSearcher.size((int)doc);
            int index = 0;
            while (index < fcount) {
                this.m_collector.collect(this.m_numSearcher.get((int)doc, index), values);
                ++index;
            }
        }

        @Override
        public void collectEmptyGroups(BdLongSet values) {
            this.m_collector.collectEmptyGroups(values);
        }

        @Override
        public MGName getField(long value) {
            return this.m_collector.getField(value);
        }

        @Override
        public boolean requiresOrdering() {
            return this.m_collector.requiresOrdering();
        }
    }

    public static class EndTextField
    extends MFCollector {
        private FieldSearcher m_fieldSearcher;
        private MFCollector m_collector;
        private IntIterator m_iter = new IntIterator();

        public EndTextField(CubeSearcher searcher, FieldDefinition fieldDef) {
            super(searcher);
            this.m_fieldSearcher = searcher.getFieldSearcher(fieldDef.getTableName(), fieldDef.getName());
            this.m_collector = new TextField(searcher, fieldDef);
        }

        @Override
        public void collect(long doc, BdLongSet values) {
            this.m_fieldSearcher.fields((int)doc, this.m_iter);
            int i = 0;
            while (i < this.m_iter.count()) {
                this.m_collector.collect(this.m_iter.get(i), values);
                ++i;
            }
        }

        @Override
        public void collectEmptyGroups(BdLongSet values) {
            this.m_collector.collectEmptyGroups(values);
        }

        @Override
        public MGName getField(long value) {
            return this.m_collector.getField(value);
        }

        @Override
        public boolean requiresOrdering() {
            return this.m_collector.requiresOrdering();
        }
    }

    public static class FilteredCollector
    extends MFCollector {
        private Result m_filter;
        private MFCollector m_collector;

        public FilteredCollector(Result filter, MFCollector inner) {
            super(inner.searcher);
            this.m_filter = filter;
            this.m_collector = inner;
        }

        @Override
        public void collect(long doc, BdLongSet values) {
            if (doc < 0L || this.m_filter.get((int)doc)) {
                this.m_collector.collect(doc, values);
            }
        }

        @Override
        public void collectEmptyGroups(BdLongSet values) {
            this.m_collector.collectEmptyGroups(values);
        }

        @Override
        public MGName getField(long value) {
            return this.m_collector.getField(value);
        }

        @Override
        public boolean requiresOrdering() {
            return this.m_collector.requiresOrdering();
        }
    }

    public static class FloatField
    extends MFCollector {
        public FloatField(CubeSearcher searcher) {
            super(searcher);
        }

        @Override
        public void collect(long doc, BdLongSet values) {
            if (doc < 0L) {
                doc = -(doc & Integer.MAX_VALUE);
            }
            values.add(doc);
        }

        @Override
        public MGName getField(long value) {
            if (value < 0L) {
                value = -value | Integer.MIN_VALUE;
            }
            float fval = Float.intBitsToFloat((int)value);
            return new MGName(XType.toString(fval), new BSTR(fval));
        }

        @Override
        public boolean requiresOrdering() {
            return false;
        }
    }

    public static class IdField
    extends MFCollector {
        private IdSearcher m_idSearcher;

        public IdField(CubeSearcher searcher, TableDefinition tableDef) {
            super(searcher);
            this.m_idSearcher = searcher.getIdSearcher(tableDef.getTableName());
        }

        @Override
        public void collect(long doc, BdLongSet values) {
            values.add(doc);
        }

        @Override
        public MGName getField(long value) {
            return new MGName(this.m_idSearcher.getId((int)value).toString());
        }

        @Override
        public boolean requiresOrdering() {
            return true;
        }
    }

    public static class LinkField
    extends MFCollector {
        private Result m_filter;
        private FieldSearcher m_fieldSearcher;
        private MFCollector m_collector;
        private IntIterator m_iter = new IntIterator();

        public LinkField(CubeSearcher searcher, FieldDefinition fieldDef, Result filter, MFCollector inner) {
            super(searcher);
            this.m_filter = filter;
            this.m_fieldSearcher = searcher.getFieldSearcher(fieldDef.getTableName(), fieldDef.getName());
            this.m_collector = inner;
        }

        @Override
        public void collect(long doc, BdLongSet values) {
            this.m_fieldSearcher.fields((int)doc, this.m_iter);
            int i = 0;
            while (i < this.m_iter.count()) {
                int d = this.m_iter.get(i);
                if (this.m_filter == null || this.m_filter.get(d)) {
                    this.m_collector.collect(this.m_iter.get(i), values);
                }
                ++i;
            }
        }

        @Override
        public void collectEmptyGroups(BdLongSet values) {
            this.m_collector.collectEmptyGroups(values);
        }

        @Override
        public MGName getField(long value) {
            return this.m_collector.getField(value);
        }

        @Override
        public boolean requiresOrdering() {
            return this.m_collector.requiresOrdering();
        }
    }

    public static class LongField
    extends MFCollector {
        public LongField(CubeSearcher searcher) {
            super(searcher);
        }

        @Override
        public void collect(long doc, BdLongSet values) {
            values.add(doc);
        }

        @Override
        public MGName getField(long value) {
            return new MGName(value);
        }

        @Override
        public boolean requiresOrdering() {
            return false;
        }
    }

    public static class NullField
    extends MFCollector {
        public NullField(CubeSearcher searcher) {
            super(searcher);
        }

        @Override
        public void collect(long doc, BdLongSet values) {
            values.add(0L);
        }

        @Override
        public MGName getField(long value) {
            return new MGName("*");
        }

        @Override
        public boolean requiresOrdering() {
            return false;
        }
    }

    public static class NumBatchField
    extends MFCollector {
        private long[] m_batches;

        public NumBatchField(CubeSearcher searcher, List<? extends Object> batches) {
            super(searcher);
            this.m_batches = new long[batches.size()];
            int i = 0;
            while (i < this.m_batches.length) {
                this.m_batches[i] = Long.parseLong(batches.get(i).toString());
                ++i;
            }
        }

        @Override
        public void collect(long doc, BdLongSet values) {
            int pos = 0;
            while (pos < this.m_batches.length && this.m_batches[pos] <= doc) {
                ++pos;
            }
            values.add(pos);
        }

        @Override
        public MGName getField(long value) {
            int field = (int)value;
            String v = null;
            v = field == 0 ? "< " + this.m_batches[0] : (field == this.m_batches.length ? ">= " + this.m_batches[field - 1] : String.valueOf(this.m_batches[field - 1]) + " - " + this.m_batches[field]);
            return new MGName(v, new BSTR(value));
        }

        @Override
        public void collectEmptyGroups(BdLongSet values) {
            long l = 0L;
            while (l <= (long)this.m_batches.length) {
                values.add(l);
                ++l;
            }
        }

        @Override
        public boolean requiresOrdering() {
            return false;
        }
    }

    public static class NumDoubleBatchField
    extends MFCollector {
        private double[] m_batches;

        public NumDoubleBatchField(CubeSearcher searcher, List<? extends Object> batches) {
            super(searcher);
            this.m_batches = new double[batches.size()];
            int i = 0;
            while (i < this.m_batches.length) {
                this.m_batches[i] = Double.parseDouble(batches.get(i).toString());
                ++i;
            }
        }

        @Override
        public void collect(long doc, BdLongSet values) {
            double d = Double.longBitsToDouble(doc);
            int pos = 0;
            while (pos < this.m_batches.length && this.m_batches[pos] <= d) {
                ++pos;
            }
            values.add(pos);
        }

        @Override
        public MGName getField(long value) {
            int field = (int)value;
            String v = null;
            v = field == 0 ? "< " + XType.toString(this.m_batches[0]) : (field == this.m_batches.length ? ">= " + XType.toString(this.m_batches[field - 1]) : String.valueOf(XType.toString(this.m_batches[field - 1])) + " - " + XType.toString(this.m_batches[field]));
            return new MGName(v, new BSTR(value));
        }

        @Override
        public void collectEmptyGroups(BdLongSet values) {
            long l = 0L;
            while (l <= (long)this.m_batches.length) {
                values.add(l);
                ++l;
            }
        }

        @Override
        public boolean requiresOrdering() {
            return false;
        }
    }

    public static class NumFloatBatchField
    extends MFCollector {
        private float[] m_batches;

        public NumFloatBatchField(CubeSearcher searcher, List<? extends Object> batches) {
            super(searcher);
            this.m_batches = new float[batches.size()];
            int i = 0;
            while (i < this.m_batches.length) {
                this.m_batches[i] = Float.parseFloat(batches.get(i).toString());
                ++i;
            }
        }

        @Override
        public void collect(long doc, BdLongSet values) {
            double d = Float.intBitsToFloat((int)doc);
            int pos = 0;
            while (pos < this.m_batches.length && (double)this.m_batches[pos] <= d) {
                ++pos;
            }
            values.add(pos);
        }

        @Override
        public MGName getField(long value) {
            int field = (int)value;
            String v = null;
            v = field == 0 ? "< " + XType.toString(this.m_batches[0]) : (field == this.m_batches.length ? ">= " + XType.toString(this.m_batches[field - 1]) : String.valueOf(XType.toString(this.m_batches[field - 1])) + " - " + XType.toString(this.m_batches[field]));
            return new MGName(v, new BSTR(value));
        }

        @Override
        public void collectEmptyGroups(BdLongSet values) {
            long l = 0L;
            while (l <= (long)this.m_batches.length) {
                values.add(l);
                ++l;
            }
        }

        @Override
        public boolean requiresOrdering() {
            return false;
        }
    }

    public static class TextField
    extends MFCollector {
        private ValueSearcher m_valueSearcher;

        public TextField(CubeSearcher searcher, FieldDefinition fieldDef) {
            super(searcher);
            this.m_valueSearcher = searcher.getValueSearcher(fieldDef.getTableName(), fieldDef.getName());
        }

        @Override
        public void collect(long doc, BdLongSet values) {
            values.add(doc);
        }

        @Override
        public MGName getField(long value) {
            String name = this.m_valueSearcher.getValue((int)value).toString();
            return new MGName(name, new BSTR(name.toLowerCase()));
        }

        @Override
        public boolean requiresOrdering() {
            return true;
        }
    }

    public static class TransitiveLinkField
    extends MFCollector {
        private Result m_filter;
        private FieldSearcher m_fieldSearcher;
        private MFCollector m_collector;
        private IntIterator m_iter = new IntIterator();
        private BdLongSet m_set;
        private int m_depth;

        public TransitiveLinkField(CubeSearcher searcher, FieldDefinition fieldDef, int depth, Result filter, MFCollector inner) {
            super(searcher);
            this.m_filter = filter;
            this.m_fieldSearcher = searcher.getFieldSearcher(fieldDef.getTableName(), fieldDef.getName());
            this.m_collector = inner;
            this.m_set = new BdLongSet(1024);
            this.m_set.enableClearBuffer();
            this.m_depth = Math.min(depth, 1024);
            if (this.m_depth == 0) {
                this.m_depth = 1024;
            }
        }

        @Override
        public void collect(long doc, BdLongSet values) {
            this.m_set.clear();
            this.m_set.add(doc);
            int last_size = 0;
            int depth = 0;
            while (depth < this.m_depth) {
                int current_size = this.m_set.size();
                if (current_size == last_size) break;
                int i = last_size;
                while (i < current_size) {
                    doc = this.m_set.get(i);
                    this.m_fieldSearcher.fields((int)doc, this.m_iter);
                    int j = 0;
                    while (j < this.m_iter.count()) {
                        int d = this.m_iter.get(j);
                        this.m_set.add(d);
                        ++j;
                    }
                    ++i;
                }
                last_size = current_size;
                ++depth;
            }
            int i = 1;
            while (i < this.m_set.size()) {
                long d = this.m_set.get(i);
                if (this.m_filter == null || this.m_filter.get((int)d)) {
                    this.m_collector.collect(d, values);
                }
                ++i;
            }
            this.m_set.clear();
        }

        @Override
        public void collectEmptyGroups(BdLongSet values) {
            this.m_collector.collectEmptyGroups(values);
        }

        @Override
        public MGName getField(long value) {
            return this.m_collector.getField(value);
        }

        @Override
        public boolean requiresOrdering() {
            return this.m_collector.requiresOrdering();
        }
    }
}

