/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.aggregate.mr;

import com.dell.doradus.common.ApplicationDefinition;
import com.dell.doradus.olap.Olap;
import com.dell.doradus.olap.aggregate.AggregationRequest;
import com.dell.doradus.olap.aggregate.AggregationResult;
import com.dell.doradus.olap.aggregate.MetricCollectorFactory;
import com.dell.doradus.olap.aggregate.MetricCollectorSet;
import com.dell.doradus.olap.aggregate.MetricCounterFactory;
import com.dell.doradus.olap.aggregate.MetricCounterSet;
import com.dell.doradus.olap.aggregate.MetricValueSet;
import com.dell.doradus.olap.aggregate.mr.AggregationCollector;
import com.dell.doradus.olap.aggregate.mr.AggregationResultBuilder;
import com.dell.doradus.olap.aggregate.mr.MFCollectorSet;
import com.dell.doradus.olap.aggregate.mr.MGBuilder;
import com.dell.doradus.olap.collections.BdLongSet;
import com.dell.doradus.olap.io.FileDeletedException;
import com.dell.doradus.olap.search.Result;
import com.dell.doradus.olap.search.ResultBuilder;
import com.dell.doradus.olap.store.CubeSearcher;
import com.dell.doradus.search.aggregate.AggregationGroup;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MFAggregationBuilder {
    private static Logger LOG = LoggerFactory.getLogger((String)"MFAggregationBuilder");

    public static AggregationResult aggregate(Olap olap, ApplicationDefinition appDef, AggregationRequest request) {
        AggregationCollector collector = Olap.getSearchThreadPool() == null ? MFAggregationBuilder.searchSinglethreaded(olap, appDef, request) : MFAggregationBuilder.searchMultithreaded(olap, appDef, request);
        AggregationResult result = AggregationResultBuilder.build(request, collector);
        if (request.flat) {
            int topGroupsCount = 0;
            int lastSubgroups = 0;
            int maxGroups = request.getTop(0);
            int curGroups = 0;
            int i = 0;
            while (i < result.groups.size()) {
                ++topGroupsCount;
                AggregationResult.AggregationGroup group = result.groups.get(i);
                int subGroups = group.innerResult.groups.size();
                if (curGroups + subGroups >= maxGroups) {
                    lastSubgroups = maxGroups - curGroups;
                    break;
                }
                curGroups += subGroups;
                ++i;
            }
            if (result.groups.size() > topGroupsCount) {
                ArrayList<AggregationResult.AggregationGroup> grp = new ArrayList<AggregationResult.AggregationGroup>(topGroupsCount);
                int i2 = 0;
                while (i2 < topGroupsCount) {
                    grp.add(result.groups.get(i2));
                    ++i2;
                }
                result.groups = grp;
            }
            AggregationResult last = result.groups.get((int)(topGroupsCount - 1)).innerResult;
            if (last.groups.size() > lastSubgroups) {
                ArrayList<AggregationResult.AggregationGroup> grp = new ArrayList<AggregationResult.AggregationGroup>(lastSubgroups);
                int i3 = 0;
                while (i3 < lastSubgroups) {
                    grp.add(last.groups.get(i3));
                    ++i3;
                }
                last.groups = grp;
            }
        }
        return result;
    }

    private static AggregationCollector searchSinglethreaded(Olap olap, ApplicationDefinition appDef, AggregationRequest request) {
        AggregationCollector collector = null;
        for (String shard : request.shards) {
            AggregationCollector agg = MFAggregationBuilder.aggregate(olap, appDef, shard, request);
            if (collector == null) {
                collector = agg;
                continue;
            }
            collector.merge(agg);
        }
        if (collector == null) {
            collector = new AggregationCollector(0);
        }
        return collector;
    }

    /*
     * WARNING - void declaration
     */
    private static AggregationCollector searchMultithreaded(Olap olap, ApplicationDefinition appDef, AggregationRequest request) {
        try {
            void var5_15;
            void var5_12;
            final ArrayList results = new ArrayList();
            ArrayList futures = new ArrayList();
            for (String string : request.shards) {
                final Olap f_olap = olap;
                final ApplicationDefinition f_appDef = appDef;
                final String f_shard = string;
                final AggregationRequest f_request = request;
                futures.add(Olap.getSearchThreadPool().submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        AggregationCollector agg = MFAggregationBuilder.aggregate(f_olap, f_appDef, f_shard, f_request);
                        List list = results;
                        synchronized (list) {
                            results.add(agg);
                        }
                    }
                }));
            }
            for (Future future : futures) {
                future.get();
            }
            futures.clear();
            Object var5_11 = null;
            for (AggregationCollector agg : results) {
                if (var5_12 == null) {
                    AggregationCollector aggregationCollector = agg;
                    continue;
                }
                var5_12.merge(agg);
            }
            if (var5_12 == null) {
                AggregationCollector aggregationCollector = new AggregationCollector(0);
            }
            return var5_15;
        }
        catch (ExecutionException ee) {
            throw new RuntimeException(ee);
        }
        catch (InterruptedException ee) {
            throw new RuntimeException(ee);
        }
    }

    private static AggregationCollector aggregate(Olap olap, ApplicationDefinition appDef, String shard, AggregationRequest request) {
        int i = 0;
        while (i < 2) {
            try {
                CubeSearcher searcher = olap.getSearcher(appDef, shard);
                return MFAggregationBuilder.aggregate(searcher, request);
            }
            catch (FileDeletedException ex) {
                LOG.warn(String.valueOf(ex.getMessage()) + " - retrying: " + i);
                ++i;
            }
        }
        CubeSearcher searcher = olap.getSearcher(appDef, shard);
        return MFAggregationBuilder.aggregate(searcher, request);
    }

    public static AggregationCollector aggregate(CubeSearcher searcher, AggregationRequest request) {
        AggregationRequest.Part[] partArray = request.parts;
        int n = request.parts.length;
        int n2 = 0;
        while (n2 < n) {
            AggregationRequest.Part p = partArray[n2];
            if (p.groups == null) {
                p.groups = new ArrayList<AggregationGroup>();
            }
            ++n2;
        }
        int groupsCount = request.parts[0].groups.size();
        int partsCount = request.parts.length;
        Result[] filters = new Result[partsCount];
        MFCollectorSet[] fieldCollectors = new MFCollectorSet[partsCount];
        MetricCollectorSet[] collectorSets = new MetricCollectorSet[partsCount];
        MetricCounterSet[] counterSets = new MetricCounterSet[partsCount];
        int i = 0;
        while (i < filters.length) {
            filters[i] = ResultBuilder.search(request.tableDef, request.parts[i].query, searcher);
            fieldCollectors[i] = new MFCollectorSet(searcher, request.parts[i].groups, filters.length == 1);
            collectorSets[i] = MetricCollectorFactory.create(searcher, request.parts[i].metrics);
            counterSets[i] = MetricCounterFactory.create(searcher, request.parts[i].metrics);
            ++i;
        }
        if (request.isOnlyCountStar()) {
            Result r = filters[0];
            int i2 = 1;
            while (i2 < filters.length) {
                r.or(filters[i2]);
                ++i2;
            }
            AggregationCollector collector = new AggregationCollector(r.countSet());
            return collector;
        }
        BdLongSet[] sets = new BdLongSet[groupsCount];
        int i3 = 0;
        while (i3 < groupsCount) {
            sets[i3] = new BdLongSet(1024);
            sets[i3].enableClearBuffer();
            ++i3;
        }
        MGBuilder builder = new MGBuilder(searcher, collectorSets[0], groupsCount);
        MetricValueSet valueSet = collectorSets[0].get();
        if (groupsCount > 0 && fieldCollectors[0].collectors.length > 0) {
            fieldCollectors[0].collectors[0].collectEmptyGroups(sets[0]);
            if (sets[0].size() > 0) {
                builder.add(-1, sets, valueSet);
            }
            sets[0].clear();
        }
        boolean hasCommonPart = filters.length == 1 && fieldCollectors[0].commonPartCollector != null;
        int count = filters[0].size();
        if (hasCommonPart) {
            BdLongSet commonSet = new BdLongSet(1024);
            commonSet.enableClearBuffer();
            int doc = 0;
            while (doc < count) {
                int i4 = 0;
                while (i4 < filters.length) {
                    if (filters[i4].get(doc)) {
                        valueSet.reset();
                        counterSets[i4].add(doc, valueSet);
                        fieldCollectors[0].commonPartCollector.collect(doc, commonSet);
                        int d = 0;
                        while (d < commonSet.size()) {
                            long commonDoc = commonSet.get(d);
                            fieldCollectors[i4].collect(commonDoc, sets);
                            if (i4 > 0 && request.differentMetricsForPairs) {
                                builder.add(doc + i4 * count, sets, valueSet);
                            } else {
                                builder.add(doc, sets, valueSet);
                            }
                            int j = 0;
                            while (j < sets.length) {
                                sets[j].clear();
                                ++j;
                            }
                            ++d;
                        }
                        commonSet.clear();
                    }
                    ++i4;
                }
                ++doc;
            }
        } else {
            int doc = 0;
            while (doc < count) {
                int i5 = 0;
                while (i5 < filters.length) {
                    if (filters[i5].get(doc)) {
                        valueSet.reset();
                        counterSets[i5].add(doc, valueSet);
                        fieldCollectors[i5].collect(doc, sets);
                        if (i5 > 0 && request.differentMetricsForPairs) {
                            builder.add(doc + i5 * count, sets, valueSet);
                        } else {
                            builder.add(doc, sets, valueSet);
                        }
                        int j = 0;
                        while (j < sets.length) {
                            sets[j].clear();
                            ++j;
                        }
                    }
                    ++i5;
                }
                ++doc;
            }
        }
        AggregationCollector result = builder.createResult(request.parts[0].groups, fieldCollectors[0]);
        return result;
    }
}

