/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.aggregate.mr;

import com.dell.doradus.fieldanalyzer.SimpleTextAnalyzer;
import com.dell.doradus.olap.aggregate.mr.MGName;
import com.dell.doradus.search.aggregate.AggregationGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class AggregationTokenizer {
    private List<Set<String>> m_stopWords;

    public AggregationTokenizer(List<AggregationGroup> groups) {
        this.m_stopWords = new ArrayList<Set<String>>(groups.size());
        for (AggregationGroup group : groups) {
            List<String> stopWords = group.stopWords;
            if (stopWords != null) {
                this.m_stopWords.add(new HashSet<String>(stopWords));
                continue;
            }
            this.m_stopWords.add(null);
        }
    }

    public boolean needsTokenizing(int level) {
        return this.m_stopWords.get(level) != null;
    }

    public Collection<MGName> tokenize(int level, MGName name) {
        String[] tokens = SimpleTextAnalyzer.instance().tokenize(name.name);
        ArrayList<MGName> names = new ArrayList<MGName>(tokens.length);
        String[] stringArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            if (!this.m_stopWords.contains(token)) {
                names.add(new MGName(token));
            }
            ++n2;
        }
        return names;
    }
}

