/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.aggregate.mr;

import com.dell.doradus.olap.aggregate.MetricCollectorSet;
import com.dell.doradus.olap.aggregate.MetricValueSet;
import com.dell.doradus.olap.aggregate.mr.MFCollectorSet;
import com.dell.doradus.olap.aggregate.mr.MGName;
import com.dell.doradus.olap.collections.BdLongMap;
import com.dell.doradus.olap.collections.BdLongSet;
import java.util.ArrayList;
import java.util.List;

public class AggregationCollectorRaw {
    private MetricCollectorSet m_mcs;
    private int m_documentsCount;
    private int m_lastAddedDoc = -1;
    private Group m_group;

    public AggregationCollectorRaw(MetricCollectorSet mcs) {
        this.m_mcs = mcs;
        this.m_group = new Group(Long.MIN_VALUE, mcs.get());
    }

    public int documentsCount() {
        return this.m_documentsCount;
    }

    public Group getGroup() {
        return this.m_group;
    }

    public MetricCollectorSet getMetricCollectorSet() {
        return this.m_mcs;
    }

    public void add(int doc, BdLongSet[] keys, MetricValueSet metric) {
        if (doc >= 0 && doc != this.m_lastAddedDoc) {
            ++this.m_documentsCount;
            this.m_group.m_value.add(metric);
            this.m_lastAddedDoc = doc;
        }
        this.m_group.add(doc, keys, 0, metric);
    }

    public List<BdLongMap<MGName>> createNamesMap(MFCollectorSet mfc) {
        int len = mfc.size();
        BdLongSet[] valuesSet = new BdLongSet[len];
        int i = 0;
        while (i < len) {
            if (mfc.collectors[i].requiresOrdering()) {
                valuesSet[i] = new BdLongSet(1024);
            }
            ++i;
        }
        this.m_group.fillValueSet(valuesSet, 0);
        ArrayList<BdLongMap<MGName>> mapSet = new ArrayList<BdLongMap<MGName>>(valuesSet.length);
        int i2 = 0;
        while (i2 < len) {
            BdLongSet vset = valuesSet[i2];
            if (vset == null) {
                mapSet.add(null);
            } else {
                vset.sort();
                BdLongMap<MGName> map = new BdLongMap<MGName>(vset.size());
                mapSet.add(map);
                int j = 0;
                while (j < vset.size()) {
                    long val = vset.get(j);
                    if (val != Long.MIN_VALUE) {
                        map.put(val, mfc.collectors[i2].getField(val));
                    }
                    ++j;
                }
            }
            ++i2;
        }
        return mapSet;
    }

    public class Group
    implements Comparable<Group> {
        private long m_key;
        private MetricValueSet m_value;
        private BdLongMap<Group> m_groups;
        private int m_lastDoc;

        Group(long key, MetricValueSet value) {
            this.m_key = key;
            this.m_value = value;
            this.m_lastDoc = -1;
        }

        public long getKey() {
            return this.m_key;
        }

        public MetricValueSet getMetric() {
            return this.m_value;
        }

        public BdLongMap<Group> groups() {
            return this.m_groups;
        }

        public void add(MetricValueSet metric) {
            this.m_value.add(metric);
        }

        @Override
        public int compareTo(Group o) {
            if (this.m_key > o.m_key) {
                return 1;
            }
            if (this.m_key < o.m_key) {
                return -1;
            }
            return 0;
        }

        public int hashCode() {
            return (int)(this.m_key ^ this.m_key >>> 32);
        }

        public boolean equals(Object obj) {
            Group g = (Group)obj;
            return this.m_key == g.m_key;
        }

        public String toString() {
            return this.m_key + "=" + this.m_value.toString();
        }

        void add(int doc, BdLongSet[] keys, int index, MetricValueSet metric) {
            if (index == keys.length) {
                return;
            }
            BdLongSet keySet = keys[index];
            if (this.m_groups == null) {
                this.m_groups = new BdLongMap(index == 0 ? 1024 : 4);
            }
            int i = 0;
            while (i < keySet.size()) {
                long key = keySet.get(i);
                Group group = this.m_groups.get(key);
                if (group == null) {
                    MetricValueSet m = AggregationCollectorRaw.this.m_mcs.get();
                    group = new Group(key, m);
                    this.m_groups.put(key, group);
                }
                if (doc < 0 || doc != group.m_lastDoc) {
                    group.m_value.add(metric);
                    group.m_lastDoc = doc;
                }
                if (index + 1 < keys.length) {
                    group.add(doc, keys, index + 1, metric);
                }
                ++i;
            }
            if (keySet.size() == 0) {
                long key = Long.MIN_VALUE;
                Group group = this.m_groups.get(key);
                if (group == null) {
                    MetricValueSet m = AggregationCollectorRaw.this.m_mcs.get();
                    group = new Group(key, m);
                    this.m_groups.put(key, group);
                }
                if (doc < 0 || doc != group.m_lastDoc) {
                    group.m_value.add(metric);
                    group.m_lastDoc = doc;
                }
                if (index + 1 < keys.length) {
                    group.add(doc, keys, index + 1, metric);
                }
            }
        }

        void fillValueSet(BdLongSet[] keys, int index) {
            if (this.m_groups == null) {
                return;
            }
            BdLongSet keySet = keys[index];
            int i = 0;
            while (i < this.m_groups.size()) {
                Group child = this.m_groups.getAt(i);
                long key = child.getKey();
                if (key != Long.MIN_VALUE && keySet != null) {
                    keySet.add(key);
                }
                child.fillValueSet(keys, index + 1);
                ++i;
            }
        }
    }
}

