/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.aggregate.mr;

import com.dell.doradus.olap.aggregate.MetricCollectorSet;
import com.dell.doradus.olap.aggregate.MetricValueSet;
import com.dell.doradus.olap.aggregate.mr.AggregationChangeCasing;
import com.dell.doradus.olap.aggregate.mr.AggregationCollectorRaw;
import com.dell.doradus.olap.aggregate.mr.AggregationIncludeExclude;
import com.dell.doradus.olap.aggregate.mr.AggregationTokenizer;
import com.dell.doradus.olap.aggregate.mr.MFCollectorSet;
import com.dell.doradus.olap.aggregate.mr.MGName;
import com.dell.doradus.olap.collections.BdLongMap;
import com.dell.doradus.search.aggregate.AggregationGroup;
import com.dell.doradus.search.util.HeapSort;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class AggregationCollector {
    private static List<Group> EMPTY_GROUPS = new ArrayList<Group>(0);
    private MetricCollectorSet m_mcs;
    private int m_documentsCount;
    private Group m_group;
    private AggregationTokenizer m_tokenizer;
    private AggregationChangeCasing m_changeCasing;
    private AggregationIncludeExclude m_includeExclude;

    public AggregationCollector(int documents) {
        this.m_documentsCount = documents;
    }

    public AggregationCollector(MFCollectorSet mfc, AggregationCollectorRaw rawCollector, List<AggregationGroup> groups) {
        this.m_tokenizer = new AggregationTokenizer(groups);
        this.m_changeCasing = new AggregationChangeCasing(groups);
        this.m_includeExclude = new AggregationIncludeExclude(groups);
        this.m_mcs = rawCollector.getMetricCollectorSet();
        this.m_documentsCount = rawCollector.documentsCount();
        if (this.m_documentsCount == 0) {
            return;
        }
        List<BdLongMap<MGName>> namesMap = rawCollector.createNamesMap(mfc);
        this.m_group = new Group(MGName.NullGroup, rawCollector.getGroup().getMetric());
        this.m_group.add(mfc, namesMap, rawCollector.getGroup(), 0);
        this.m_group.resort(0);
    }

    public int documentsCount() {
        return this.m_documentsCount;
    }

    public Group getGroup() {
        return this.m_group;
    }

    public void merge(AggregationCollector collector) {
        this.m_documentsCount += collector.m_documentsCount;
        if (this.m_group == null) {
            this.m_group = collector.m_group;
        } else if (collector.m_group != null) {
            this.m_group.merge(collector.m_group);
        }
    }

    public class Group
    implements Comparable<Group> {
        private MGName m_key;
        private MetricValueSet m_value;
        private List<Group> m_groups;

        public Collection<Group> groups() {
            return this.m_groups == null ? EMPTY_GROUPS : this.m_groups;
        }

        Group(MGName name, MetricValueSet metric) {
            this.m_key = name;
            this.m_value = metric;
            AggregationCollector.this.m_mcs.convert(metric);
        }

        void add(MFCollectorSet mfc, List<BdLongMap<MGName>> namesMap, AggregationCollectorRaw.Group rawGroup, int level) {
            if (rawGroup.groups() == null) {
                return;
            }
            this.m_groups = new ArrayList<Group>(rawGroup.groups().size());
            int i = 0;
            while (i < rawGroup.groups().size()) {
                AggregationCollectorRaw.Group rawChild = rawGroup.groups().getAt(i);
                MGName key = MGName.NullGroup;
                if (rawChild.getKey() != Long.MIN_VALUE) {
                    MGName mGName = key = namesMap.get(level) == null ? mfc.collectors[level].getField(rawChild.getKey()) : namesMap.get(level).get(rawChild.getKey());
                }
                if (AggregationCollector.this.m_includeExclude.accept(key, level)) {
                    Group child = new Group(key, rawChild.getMetric());
                    this.m_groups.add(child);
                    child.add(mfc, namesMap, rawChild, level + 1);
                }
                ++i;
            }
            if (this.m_groups.size() == 0) {
                this.m_groups = null;
            }
        }

        @Override
        public int compareTo(Group o) {
            return this.m_key.compareTo(o.m_key);
        }

        public int hashCode() {
            return this.m_key.hashCode();
        }

        public boolean equals(Object obj) {
            Group o = (Group)obj;
            return this.m_key.equals(o.m_key);
        }

        public String toString() {
            return String.valueOf(this.m_key.toString()) + "=" + this.m_value.toString();
        }

        public void add(MetricValueSet metric) {
            this.m_value.add(metric);
        }

        public MGName getKey() {
            return this.m_key;
        }

        public MetricValueSet getValue() {
            return this.m_value;
        }

        public void merge(Group group) {
            if (group == null) {
                return;
            }
            this.m_value.add(group.m_value);
            if (group.m_groups == null) {
                return;
            }
            if (this.m_groups == null) {
                this.m_groups = group.m_groups;
                return;
            }
            HeapSort<Group> sgroups = new HeapSort<Group>();
            sgroups.add(this.m_groups);
            sgroups.add(group.m_groups);
            ArrayList<Group> newgroups = new ArrayList<Group>();
            Group current = null;
            for (Group next : sgroups) {
                if (current == null) {
                    current = next;
                    continue;
                }
                if (current.equals(next)) {
                    current.merge(next);
                    newgroups.add(current);
                    current = null;
                    continue;
                }
                newgroups.add(current);
                current = next;
            }
            if (current != null) {
                newgroups.add(current);
            }
            this.m_groups = newgroups;
        }

        /*
         * WARNING - void declaration
         */
        void resort(int level) {
            void var3_11;
            if (this.m_groups == null) {
                return;
            }
            for (Group grp : this.m_groups) {
                grp.resort(level + 1);
            }
            if (AggregationCollector.this.m_tokenizer.needsTokenizing(level)) {
                HashMap<MGName, Group> map = new HashMap<MGName, Group>();
                for (Group group : this.m_groups) {
                    if (group.m_key == MGName.NullGroup) {
                        map.put(MGName.NullGroup, group);
                        continue;
                    }
                    for (MGName mGName : AggregationCollector.this.m_tokenizer.tokenize(level, group.m_key)) {
                        Group g = (Group)map.get(mGName);
                        if (g == null) {
                            MetricValueSet v = AggregationCollector.this.m_mcs.get();
                            g = new Group(mGName, v);
                            map.put(mGName, g);
                        }
                        g.m_value.add(group.m_value);
                    }
                }
                this.m_groups = new ArrayList(map.values());
            }
            if (AggregationCollector.this.m_changeCasing.needsChangeCasing(level)) {
                for (Group grp : this.m_groups) {
                    AggregationCollector.this.m_changeCasing.changeCase(level, grp.m_key);
                }
            }
            Collections.sort(this.m_groups);
            boolean needsMerging = false;
            Object var3_7 = null;
            for (Group group : this.m_groups) {
                void var3_8;
                if (var3_8 != null && var3_8.equals(group)) {
                    needsMerging = true;
                    break;
                }
                Group group2 = group;
            }
            if (!needsMerging) {
                return;
            }
            ArrayList<Group> newgroups = new ArrayList<Group>();
            Object var3_10 = null;
            for (Group group : this.m_groups) {
                if (var3_11 != null && var3_11.equals(group)) {
                    var3_11.merge(group);
                    continue;
                }
                if (var3_11 != null) {
                    newgroups.add((Group)var3_11);
                }
                Group group3 = group;
            }
            if (var3_11 != null) {
                newgroups.add((Group)var3_11);
            }
            this.m_groups = newgroups;
        }
    }
}

