/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.aggregate.mr;

import com.dell.doradus.common.Utils;
import com.dell.doradus.olap.aggregate.mr.MGName;
import com.dell.doradus.search.aggregate.AggregationGroup;
import java.util.List;

public class AggregationChangeCasing {
    private boolean[] m_bToUpper;
    private boolean[] m_bToLower;

    public AggregationChangeCasing(List<AggregationGroup> groups) {
        this.m_bToUpper = new boolean[groups.size()];
        this.m_bToLower = new boolean[groups.size()];
        int i = 0;
        while (i < groups.size()) {
            AggregationGroup group = groups.get(i);
            String tocase = group.tocase;
            if (tocase != null) {
                if ("UPPER".equals(tocase)) {
                    this.m_bToUpper[i] = true;
                } else if ("LOWER".equals(tocase)) {
                    this.m_bToLower[i] = true;
                } else {
                    Utils.require((boolean)false, (String)"only UPPER and LOWER casing are supported");
                }
            }
            ++i;
        }
    }

    public boolean needsChangeCasing(int level) {
        return this.m_bToUpper[level] || this.m_bToLower[level];
    }

    public void changeCase(int level, MGName name) {
        if (name.name == null) {
            return;
        }
        if (this.m_bToUpper[level]) {
            name.name = name.name.toUpperCase();
        } else if (this.m_bToLower[level]) {
            name.name = name.name.toLowerCase();
        }
    }
}

