/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.aggregate;

import com.dell.doradus.common.FieldDefinition;
import com.dell.doradus.olap.aggregate.IMetricValue;
import com.dell.doradus.olap.aggregate.MetricCollector;
import com.dell.doradus.olap.aggregate.MetricValueMax;
import com.dell.doradus.olap.aggregate.MetricValueMin;
import com.dell.doradus.olap.store.CubeSearcher;
import com.dell.doradus.olap.store.IdSearcher;
import com.dell.doradus.olap.store.ValueSearcher;

public abstract class MetricValueText
implements IMetricValue {
    public String value;

    @Override
    public void reset() {
        this.value = null;
    }

    public String toString() {
        return this.value;
    }

    @Override
    public void add(long value) {
        throw new IllegalArgumentException("Invalid operation on text metrics");
    }

    @Override
    public int compareTo(IMetricValue o) {
        MetricValueText t = (MetricValueText)o;
        if (this.value == null && t.value == null) {
            return 0;
        }
        if (this.value == null) {
            return -1;
        }
        if (t.value == null) {
            return 1;
        }
        return this.value.compareToIgnoreCase(t.value);
    }

    @Override
    public boolean isDegenerate() {
        return this.value == null;
    }

    public static class Max
    extends MetricValueText {
        @Override
        public void add(IMetricValue o) {
            Max t = (Max)o;
            if (this.value == null || this.compareTo(t) < 0) {
                this.value = t.value;
            }
        }

        @Override
        public IMetricValue newInstance() {
            return new Max();
        }

        @Override
        public IMetricValue convert(MetricCollector collector) {
            return this;
        }
    }

    public static class MaxLink
    extends MetricValueMax.MaxNum {
        @Override
        public IMetricValue newInstance() {
            return new MaxLink();
        }

        @Override
        public IMetricValue convert(MetricCollector collector) {
            CubeSearcher searcher = collector.getSearcher();
            FieldDefinition fieldDef = collector.getFieldDefinition();
            Max txt = new Max();
            if (this.metric != Long.MIN_VALUE) {
                IdSearcher ids = searcher.getIdSearcher(fieldDef.getLinkExtent());
                txt.value = ids.getId((int)this.metric).toString();
            }
            return txt;
        }
    }

    public static class MaxText
    extends MetricValueMax.MaxNum {
        @Override
        public IMetricValue newInstance() {
            return new MaxText();
        }

        @Override
        public IMetricValue convert(MetricCollector collector) {
            CubeSearcher searcher = collector.getSearcher();
            FieldDefinition fieldDef = collector.getFieldDefinition();
            Max txt = new Max();
            if (this.metric != Long.MIN_VALUE) {
                ValueSearcher vs = searcher.getValueSearcher(fieldDef.getTableName(), fieldDef.getName());
                txt.value = vs.getValue((int)this.metric).toString();
            }
            return txt;
        }
    }

    public static class Min
    extends MetricValueText {
        @Override
        public void add(IMetricValue o) {
            Min t = (Min)o;
            if (this.value == null || this.compareTo(t) > 0) {
                this.value = t.value;
            }
        }

        @Override
        public IMetricValue newInstance() {
            return new Min();
        }

        @Override
        public IMetricValue convert(MetricCollector collector) {
            return this;
        }
    }

    public static class MinLink
    extends MetricValueMin.MinNum {
        @Override
        public IMetricValue newInstance() {
            return new MinLink();
        }

        @Override
        public IMetricValue convert(MetricCollector collector) {
            CubeSearcher searcher = collector.getSearcher();
            FieldDefinition fieldDef = collector.getFieldDefinition();
            Min txt = new Min();
            if (this.metric != Long.MAX_VALUE) {
                IdSearcher ids = searcher.getIdSearcher(fieldDef.getLinkExtent());
                txt.value = ids.getId((int)this.metric).toString();
            }
            return txt;
        }
    }

    public static class MinText
    extends MetricValueMin.MinNum {
        @Override
        public IMetricValue newInstance() {
            return new MinText();
        }

        @Override
        public IMetricValue convert(MetricCollector collector) {
            CubeSearcher searcher = collector.getSearcher();
            FieldDefinition fieldDef = collector.getFieldDefinition();
            Min txt = new Min();
            if (this.metric != Long.MAX_VALUE) {
                ValueSearcher vs = searcher.getValueSearcher(fieldDef.getTableName(), fieldDef.getName());
                txt.value = vs.getValue((int)this.metric).toString();
            }
            return txt;
        }
    }
}

