/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.aggregate;

import com.dell.doradus.olap.XType;
import com.dell.doradus.olap.aggregate.IMetricValue;
import com.dell.doradus.olap.aggregate.MetricCollector;
import java.util.Date;

public abstract class MetricValueMin
implements IMetricValue {
    public long metric = Long.MAX_VALUE;

    @Override
    public int compareTo(IMetricValue o) {
        MetricValueMin m = (MetricValueMin)o;
        long other_metric = m.metric;
        if (this.metric > other_metric) {
            return 1;
        }
        if (this.metric < other_metric) {
            return -1;
        }
        return 0;
    }

    @Override
    public boolean isDegenerate() {
        return this.metric == Long.MAX_VALUE;
    }

    @Override
    public void reset() {
        this.metric = Long.MAX_VALUE;
    }

    @Override
    public void add(IMetricValue value) {
        MetricValueMin m = (MetricValueMin)value;
        this.add(m.metric);
    }

    public static class MinBoolean
    extends MetricValueMin {
        @Override
        public void add(long value) {
            if (this.metric > value) {
                this.metric = value;
            }
        }

        public String toString() {
            if (this.metric == Long.MAX_VALUE) {
                return null;
            }
            return XType.toString(this.metric > 0L);
        }

        @Override
        public IMetricValue newInstance() {
            return new MinBoolean();
        }

        @Override
        public IMetricValue convert(MetricCollector collector) {
            return this;
        }
    }

    public static class MinDate
    extends MetricValueMin {
        @Override
        public void add(long value) {
            if (this.metric > value && value > 0L) {
                this.metric = value;
            }
        }

        public String toString() {
            if (this.metric == Long.MAX_VALUE) {
                return null;
            }
            return XType.toString(new Date(this.metric));
        }

        @Override
        public IMetricValue newInstance() {
            return new MinDate();
        }

        @Override
        public IMetricValue convert(MetricCollector collector) {
            return this;
        }
    }

    public static class MinNum
    extends MetricValueMin {
        @Override
        public void add(long value) {
            if (this.metric > value) {
                this.metric = value;
            }
        }

        public String toString() {
            if (this.metric == Long.MAX_VALUE) {
                return null;
            }
            return "" + this.metric;
        }

        @Override
        public IMetricValue newInstance() {
            return new MinNum();
        }

        @Override
        public IMetricValue convert(MetricCollector collector) {
            return this;
        }
    }
}

