/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.aggregate;

import com.dell.doradus.olap.XType;
import com.dell.doradus.olap.aggregate.IMetricValue;
import com.dell.doradus.olap.aggregate.MetricCollector;
import java.util.Date;

public abstract class MetricValueMax
implements IMetricValue {
    public long metric = Long.MIN_VALUE;

    @Override
    public int compareTo(IMetricValue o) {
        MetricValueMax m = (MetricValueMax)o;
        long other_metric = m.metric;
        if (this.metric > other_metric) {
            return 1;
        }
        if (this.metric < other_metric) {
            return -1;
        }
        return 0;
    }

    @Override
    public boolean isDegenerate() {
        return this.metric == Long.MIN_VALUE;
    }

    @Override
    public void reset() {
        this.metric = Long.MIN_VALUE;
    }

    @Override
    public void add(IMetricValue value) {
        MetricValueMax m = (MetricValueMax)value;
        this.add(m.metric);
    }

    public static class MaxBoolean
    extends MetricValueMax {
        @Override
        public void add(long value) {
            if (this.metric < value) {
                this.metric = value;
            }
        }

        public String toString() {
            if (this.metric == Long.MIN_VALUE) {
                return null;
            }
            return XType.toString(this.metric > 0L);
        }

        @Override
        public IMetricValue newInstance() {
            return new MaxBoolean();
        }

        @Override
        public IMetricValue convert(MetricCollector collector) {
            return this;
        }
    }

    public static class MaxDate
    extends MetricValueMax {
        @Override
        public void add(long value) {
            if (this.metric < value && value > 0L) {
                this.metric = value;
            }
        }

        public String toString() {
            if (this.metric == Long.MIN_VALUE) {
                return null;
            }
            return XType.toString(new Date(this.metric));
        }

        @Override
        public IMetricValue newInstance() {
            return new MaxDate();
        }

        @Override
        public IMetricValue convert(MetricCollector collector) {
            return this;
        }
    }

    public static class MaxNum
    extends MetricValueMax {
        @Override
        public void add(long value) {
            if (this.metric < value) {
                this.metric = value;
            }
        }

        public String toString() {
            if (this.metric == Long.MIN_VALUE) {
                return null;
            }
            return "" + this.metric;
        }

        @Override
        public IMetricValue newInstance() {
            return new MaxNum();
        }

        @Override
        public IMetricValue convert(MetricCollector collector) {
            return this;
        }
    }
}

