/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.aggregate;

import com.dell.doradus.olap.aggregate.IMetricValue;
import com.dell.doradus.olap.aggregate.MetricCollector;
import com.dell.doradus.search.aggregate.BinaryExpression;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;

public abstract class MetricValueExpr
implements IMetricValue {
    public static double getValue(IMetricValue value) {
        if (value instanceof MetricValueExpr) {
            return ((MetricValueExpr)value).getValue();
        }
        String str = value.toString();
        if (str == null || str.length() == 0) {
            return Double.MIN_VALUE;
        }
        return Double.parseDouble(str);
    }

    public abstract double getValue();

    @Override
    public boolean isDegenerate() {
        double x = this.getValue();
        return x == Double.NEGATIVE_INFINITY || x == Double.POSITIVE_INFINITY || Double.isNaN(x);
    }

    @Override
    public int compareTo(IMetricValue o) {
        return Double.compare(this.getValue(), MetricValueExpr.getValue(o));
    }

    public String toString() {
        double val = this.getValue();
        if (val == Double.MIN_VALUE || val == Double.MAX_VALUE) {
            return null;
        }
        if (val == Double.NEGATIVE_INFINITY || val == Double.POSITIVE_INFINITY) {
            return null;
        }
        long lval = Math.round(val);
        if (Math.abs(val - (double)lval) < 0.001) {
            return "" + lval;
        }
        DecimalFormat fmt = (DecimalFormat)NumberFormat.getInstance(Locale.ROOT);
        fmt.applyPattern("#.#########");
        return fmt.format(this.getValue());
    }

    public static class Binary
    extends MetricValueExpr {
        public BinaryExpression.MetricOperation operator;
        public IMetricValue first;
        public IMetricValue second;

        @Override
        public double getValue() {
            double x = Binary.getValue(this.first);
            double y = Binary.getValue(this.second);
            switch (this.operator) {
                case DIVIDE: {
                    return x / y;
                }
                case MULTIPLAY: {
                    return x * y;
                }
                case PLUS: {
                    return x + y;
                }
                case MINUS: {
                    return x - y;
                }
            }
            throw new IllegalArgumentException("Invalid Metric Operation: " + this.operator.toString());
        }

        @Override
        public void reset() {
            this.first.reset();
            this.second.reset();
        }

        @Override
        public void add(long value) {
            this.first.add(value);
            this.second.add(value);
        }

        @Override
        public void add(IMetricValue value) {
            Binary b = (Binary)value;
            this.first.add(b.first);
            this.second.add(b.second);
        }

        @Override
        public IMetricValue newInstance() {
            Binary b = new Binary();
            b.operator = this.operator;
            b.first = this.first.newInstance();
            b.second = this.second.newInstance();
            return b;
        }

        @Override
        public IMetricValue convert(MetricCollector collector) {
            this.first = this.first.convert(collector);
            this.second = this.second.convert(collector);
            return this;
        }
    }

    public static class Constant
    extends MetricValueExpr {
        public double value;

        public Constant(double value) {
            this.value = value;
        }

        @Override
        public double getValue() {
            return this.value;
        }

        @Override
        public void reset() {
        }

        @Override
        public void add(long value) {
        }

        @Override
        public void add(IMetricValue value) {
        }

        @Override
        public IMetricValue newInstance() {
            return this;
        }

        @Override
        public IMetricValue convert(MetricCollector collector) {
            return this;
        }
    }
}

