/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.aggregate;

import com.dell.doradus.olap.aggregate.IMetricValue;
import com.dell.doradus.olap.aggregate.MetricCollector;
import com.dell.doradus.olap.aggregate.MetricValueExpr;

public abstract class MetricValueDouble {

    public static class Avg
    extends MetricValueExpr {
        public int count;
        public double metric;

        @Override
        public double getValue() {
            return this.count == 0 ? Double.NEGATIVE_INFINITY : this.metric / (double)this.count;
        }

        @Override
        public void reset() {
            this.count = 0;
            this.metric = 0.0;
        }

        @Override
        public void add(IMetricValue value) {
            Avg other = (Avg)value;
            this.count += other.count;
            this.metric += other.metric;
        }

        public void add(double value) {
            ++this.count;
            this.metric += value;
        }

        @Override
        public void add(long value) {
            this.add(Double.longBitsToDouble(value));
        }

        @Override
        public IMetricValue newInstance() {
            return new Avg();
        }

        @Override
        public IMetricValue convert(MetricCollector collector) {
            return this;
        }
    }

    public static class Max
    extends MetricValueExpr {
        public double metric = Double.NEGATIVE_INFINITY;

        @Override
        public double getValue() {
            return this.metric;
        }

        @Override
        public void reset() {
            this.metric = Double.NEGATIVE_INFINITY;
        }

        @Override
        public void add(IMetricValue value) {
            Max m = (Max)value;
            this.add(m.metric);
        }

        public void add(double value) {
            if (this.metric < value) {
                this.metric = value;
            }
        }

        @Override
        public void add(long value) {
            this.add(Double.longBitsToDouble(value));
        }

        @Override
        public IMetricValue newInstance() {
            return new Max();
        }

        @Override
        public IMetricValue convert(MetricCollector collector) {
            return this;
        }
    }

    public static class Min
    extends MetricValueExpr {
        public double metric = Double.POSITIVE_INFINITY;

        @Override
        public double getValue() {
            return this.metric;
        }

        @Override
        public void reset() {
            this.metric = Double.POSITIVE_INFINITY;
        }

        @Override
        public void add(IMetricValue value) {
            Min m = (Min)value;
            this.add(m.metric);
        }

        public void add(double value) {
            if (this.metric > value) {
                this.metric = value;
            }
        }

        @Override
        public void add(long value) {
            this.add(Double.longBitsToDouble(value));
        }

        @Override
        public IMetricValue newInstance() {
            return new Min();
        }

        @Override
        public IMetricValue convert(MetricCollector collector) {
            return this;
        }
    }

    public static class Sum
    extends MetricValueExpr {
        public double metric;

        @Override
        public double getValue() {
            return this.metric;
        }

        @Override
        public void reset() {
            this.metric = 0.0;
        }

        @Override
        public void add(IMetricValue value) {
            Sum m = (Sum)value;
            this.add(m.metric);
        }

        public void add(double value) {
            this.metric += value;
        }

        @Override
        public void add(long value) {
            this.metric += Double.longBitsToDouble(value);
        }

        @Override
        public IMetricValue newInstance() {
            return new Sum();
        }

        @Override
        public IMetricValue convert(MetricCollector collector) {
            return this;
        }
    }
}

