/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.aggregate;

import com.dell.doradus.common.FieldDefinition;
import com.dell.doradus.olap.aggregate.IMetricValue;
import com.dell.doradus.olap.aggregate.MetricCollector;
import com.dell.doradus.olap.collections.BdLongSet;
import com.dell.doradus.olap.io.BSTR;
import com.dell.doradus.olap.store.CubeSearcher;
import com.dell.doradus.olap.store.IdSearcher;
import com.dell.doradus.olap.store.ValueSearcher;
import java.util.HashSet;
import java.util.Set;

public class MetricValueDistinct
implements IMetricValue {
    protected BdLongSet m_LongValues = new BdLongSet(2);
    protected Set<BSTR> m_Values = new HashSet<BSTR>();

    public MetricValueDistinct() {
        this.m_LongValues.enableClearBuffer();
    }

    public BdLongSet getLongValues() {
        return this.m_LongValues;
    }

    public Set<BSTR> getValues() {
        return this.m_Values;
    }

    public long getValue() {
        return this.m_Values.size() == 0 ? this.m_LongValues.size() : this.m_Values.size();
    }

    @Override
    public int compareTo(IMetricValue o) {
        MetricValueDistinct other = (MetricValueDistinct)o;
        return Double.compare(this.getValue(), other.getValue());
    }

    public String toString() {
        return "" + this.getValue();
    }

    @Override
    public void reset() {
        this.m_Values.clear();
        this.m_LongValues.clear();
    }

    @Override
    public void add(IMetricValue value) {
        MetricValueDistinct other = (MetricValueDistinct)value;
        this.m_Values.addAll(other.m_Values);
        this.m_LongValues.addAll(other.m_LongValues);
    }

    @Override
    public void add(long value) {
        this.m_LongValues.add(value);
    }

    @Override
    public boolean isDegenerate() {
        return false;
    }

    @Override
    public IMetricValue newInstance() {
        return new MetricValueDistinct();
    }

    @Override
    public IMetricValue convert(MetricCollector collector) {
        return this;
    }

    public static class Id
    extends MetricValueDistinct {
        @Override
        public IMetricValue newInstance() {
            return new Id();
        }

        @Override
        public IMetricValue convert(MetricCollector collector) {
            CubeSearcher searcher = collector.getSearcher();
            FieldDefinition fieldDef = collector.getFieldDefinition();
            BdLongSet longValues = this.getLongValues();
            Set<BSTR> values = this.getValues();
            if (longValues.size() == 0) {
                return this;
            }
            longValues.sort();
            IdSearcher ids = searcher.getIdSearcher(fieldDef.getLinkExtent());
            int i = 0;
            while (i < longValues.size()) {
                long l = longValues.get(i);
                if (l >= 0L) {
                    BSTR text = new BSTR(ids.getId((int)l));
                    values.add(text);
                }
                ++i;
            }
            longValues.clear();
            return this;
        }
    }

    public static class Text
    extends MetricValueDistinct {
        @Override
        public IMetricValue newInstance() {
            return new Text();
        }

        @Override
        public IMetricValue convert(MetricCollector collector) {
            CubeSearcher searcher = collector.getSearcher();
            FieldDefinition fieldDef = collector.getFieldDefinition();
            BdLongSet longValues = this.getLongValues();
            Set<BSTR> values = this.getValues();
            if (longValues.size() == 0) {
                return this;
            }
            longValues.sort();
            ValueSearcher vs = searcher.getValueSearcher(fieldDef.getTableName(), fieldDef.getName());
            int i = 0;
            while (i < longValues.size()) {
                long l = longValues.get(i);
                if (l >= 0L) {
                    BSTR text = new BSTR(vs.getValue((int)l));
                    values.add(text);
                }
                ++i;
            }
            longValues.clear();
            return this;
        }
    }
}

