/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.aggregate;

import com.dell.doradus.olap.XType;
import com.dell.doradus.olap.aggregate.IMetricValue;
import com.dell.doradus.olap.aggregate.MetricCollector;
import java.util.Date;
import java.util.Locale;

public abstract class MetricValueAvg
implements IMetricValue {
    public int count;
    public long metric;

    public double getValue() {
        return this.count == 0 ? Double.NEGATIVE_INFINITY : (double)this.metric / (double)this.count;
    }

    @Override
    public boolean isDegenerate() {
        return this.count == 0;
    }

    @Override
    public int compareTo(IMetricValue o) {
        MetricValueAvg other = (MetricValueAvg)o;
        return Double.compare(this.getValue(), other.getValue());
    }

    @Override
    public void reset() {
        this.count = 0;
        this.metric = 0L;
    }

    @Override
    public void add(IMetricValue value) {
        MetricValueAvg other = (MetricValueAvg)value;
        this.count += other.count;
        this.metric += other.metric;
    }

    public static class AvgDate
    extends MetricValueAvg {
        @Override
        public IMetricValue newInstance() {
            return new AvgDate();
        }

        @Override
        public IMetricValue convert(MetricCollector collector) {
            return this;
        }

        @Override
        public void add(long value) {
            if (value == 0L) {
                return;
            }
            ++this.count;
            this.metric += value;
        }

        public String toString() {
            if (this.count == 0) {
                return null;
            }
            long val = this.metric / (long)this.count / 1000L * 1000L;
            return XType.toString(new Date(val));
        }
    }

    public static class AvgNum
    extends MetricValueAvg {
        @Override
        public IMetricValue newInstance() {
            return new AvgNum();
        }

        @Override
        public IMetricValue convert(MetricCollector collector) {
            return this;
        }

        @Override
        public void add(long value) {
            ++this.count;
            this.metric += value;
        }

        public String toString() {
            if (this.count == 0) {
                return null;
            }
            return String.format(Locale.ROOT, "%.3f", this.getValue());
        }
    }
}

