/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.aggregate;

import com.dell.doradus.common.FieldDefinition;
import com.dell.doradus.olap.aggregate.IMetricValue;
import com.dell.doradus.olap.aggregate.MetricCounter;
import com.dell.doradus.olap.collections.BdLongSet;
import com.dell.doradus.olap.search.Result;
import com.dell.doradus.olap.store.CubeSearcher;
import com.dell.doradus.olap.store.FieldSearcher;
import com.dell.doradus.olap.store.IntIterator;

public abstract class MetricCounterTransitive
extends MetricCounter {
    protected Result m_filter;
    protected FieldSearcher m_fs;
    protected IntIterator m_iter;
    protected BdLongSet m_set;
    protected BdLongSet m_filteredSet;
    protected int m_depth;

    public abstract void addInternal(IMetricValue var1);

    public MetricCounterTransitive(Result filter, FieldDefinition fieldDef, int depth, CubeSearcher cs) {
        this.m_filter = filter;
        this.m_fs = cs.getFieldSearcher(fieldDef.getTableName(), fieldDef.getName());
        this.m_iter = new IntIterator();
        this.m_set = new BdLongSet(1024);
        this.m_set.enableClearBuffer();
        this.m_filteredSet = new BdLongSet(1024);
        this.m_filteredSet.enableClearBuffer();
        this.m_depth = Math.min(depth, 1024);
        if (this.m_depth == 0) {
            this.m_depth = 1024;
        }
    }

    @Override
    public void add(int doc, IMetricValue value) {
        this.m_set.clear();
        this.m_set.add(doc);
        int last_size = 0;
        int depth = 0;
        while (depth < this.m_depth) {
            int current_size = this.m_set.size();
            if (current_size == last_size) break;
            int i = last_size;
            while (i < current_size) {
                doc = (int)this.m_set.get(i);
                this.m_fs.fields(doc, this.m_iter);
                int j = 0;
                while (j < this.m_iter.count()) {
                    int d = this.m_iter.get(j);
                    this.m_set.add(d);
                    ++j;
                }
                ++i;
            }
            last_size = current_size;
            ++depth;
        }
        int i = 1;
        while (i < this.m_set.size()) {
            long d = this.m_set.get(i);
            if (this.m_filter == null || this.m_filter.get((int)d)) {
                this.m_filteredSet.add(d);
            }
            ++i;
        }
        this.addInternal(value);
        this.m_set.clear();
        this.m_filteredSet.clear();
    }

    public static class TransitiveLink
    extends MetricCounterTransitive {
        private MetricCounter m_inner;

        public TransitiveLink(Result filter, FieldDefinition fieldDef, int depth, CubeSearcher cs, MetricCounter inner) {
            super(filter, fieldDef, depth, cs);
            this.m_inner = inner;
        }

        @Override
        public void addInternal(IMetricValue value) {
            int i = 0;
            while (i < this.m_filteredSet.size()) {
                int d = (int)this.m_filteredSet.get(i);
                this.m_inner.add(d, value);
                ++i;
            }
        }
    }

    public static class TransitiveLinkCount
    extends MetricCounterTransitive {
        public TransitiveLinkCount(Result filter, FieldDefinition fieldDef, int depth, CubeSearcher cs) {
            super(filter, fieldDef, depth, cs);
        }

        @Override
        public void addInternal(IMetricValue value) {
            if (this.m_filteredSet.size() == 0) {
                return;
            }
            value.add(this.m_filteredSet.size());
        }
    }

    public static class TransitiveLinkValue
    extends MetricCounterTransitive {
        public TransitiveLinkValue(Result filter, FieldDefinition fieldDef, int depth, CubeSearcher cs) {
            super(filter, fieldDef, depth, cs);
        }

        @Override
        public void addInternal(IMetricValue value) {
            int i = 0;
            while (i < this.m_filteredSet.size()) {
                int d = (int)this.m_filteredSet.get(i);
                value.add(d);
                ++i;
            }
        }
    }
}

