/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.aggregate;

import com.dell.doradus.olap.aggregate.MetricCounter;
import com.dell.doradus.olap.aggregate.MetricCounterExpr;
import com.dell.doradus.olap.aggregate.MetricCounterSet;
import com.dell.doradus.olap.aggregate.MetricCounterTransitive;
import com.dell.doradus.olap.search.Result;
import com.dell.doradus.olap.search.ResultBuilder;
import com.dell.doradus.olap.store.CubeSearcher;
import com.dell.doradus.olap.store.NumSearcherMV;
import com.dell.doradus.olap.xlink.DirectXLinkMetricCounter;
import com.dell.doradus.olap.xlink.InverseXLinkMetricCounter;
import com.dell.doradus.olap.xlink.XMetrics;
import com.dell.doradus.search.aggregate.AggregationGroupItem;
import com.dell.doradus.search.aggregate.AggregationMetric;
import com.dell.doradus.search.aggregate.BinaryExpression;
import com.dell.doradus.search.aggregate.LongIntegerExpression;
import com.dell.doradus.search.aggregate.MetricExpression;
import com.dell.doradus.search.aggregate.NumberExpression;
import java.util.List;

public class MetricCounterFactory {
    public static MetricCounterSet create(CubeSearcher searcher, List<MetricExpression> metrics) {
        MetricCounterSet counterSet = new MetricCounterSet();
        counterSet.counters = new MetricCounter[metrics.size()];
        for (int i = 0; i < metrics.size(); ++i) {
            counterSet.counters[i] = MetricCounterFactory.create(searcher, metrics.get(i));
        }
        return counterSet;
    }

    public static MetricCounter create(CubeSearcher searcher, MetricExpression metric) {
        if (metric instanceof AggregationMetric) {
            return MetricCounterFactory.create(searcher, (AggregationMetric)metric);
        }
        if (metric instanceof NumberExpression) {
            return new MetricCounterExpr.Constant();
        }
        if (metric instanceof LongIntegerExpression) {
            return new MetricCounterExpr.Constant();
        }
        if (metric instanceof BinaryExpression) {
            MetricCounterExpr.Binary b = new MetricCounterExpr.Binary();
            BinaryExpression be = (BinaryExpression)metric;
            b.first = MetricCounterFactory.create(searcher, be.first);
            b.second = MetricCounterFactory.create(searcher, be.second);
            return b;
        }
        throw new IllegalArgumentException("Invalid expression type: " + metric.getClass().getName());
    }

    public static MetricCounter create(CubeSearcher searcher, AggregationMetric metric) {
        MetricCounter counter = null;
        counter = metric.items == null || metric.items.size() == 0 ? new MetricCounter.Count() : MetricCounterFactory.create(searcher, metric, 0);
        if (metric.filter != null) {
            Result result = ResultBuilder.search(metric.tableDef, metric.filter, searcher);
            counter = new MetricCounter.FilteredCounter(result, counter);
        }
        return counter;
    }

    public static MetricCounter createPartial(CubeSearcher searcher, AggregationMetric metric, int start) {
        if (metric.items == null || metric.items.size() == 0) {
            throw new RuntimeException("Count-star metric cannot be overlapped");
        }
        if (metric.filter != null) {
            throw new RuntimeException("Metric with global filter cannot be overlapped");
        }
        return MetricCounterFactory.create(searcher, metric, start);
    }

    private static MetricCounter create(CubeSearcher searcher, AggregationMetric metric, int index) {
        AggregationGroupItem item = metric.items.get(index);
        Result filter = null;
        if (item.query != null) {
            filter = ResultBuilder.search(item.tableDef, item.query, searcher);
        }
        if (index == metric.items.size() - 1) {
            if (NumSearcherMV.isNumericType(item.fieldDef.getType())) {
                if ("MINCOUNT".equals(metric.function) || "MAXCOUNT".equals(metric.function)) {
                    return new MetricCounter.NumCount(item.fieldDef, searcher);
                }
                if ("ROUNDUP".equals(metric.metricFunction)) {
                    return new MetricCounter.NumRoundup(item.fieldDef, searcher, Long.parseLong(metric.metricFunctionParameters.get(0)));
                }
                return new MetricCounter.Num(item.fieldDef, searcher);
            }
            if (item.fieldDef.isXLinkDirect()) {
                return new DirectXLinkMetricCounter(searcher, item.fieldDef, (XMetrics)item.xlinkContext);
            }
            if (item.fieldDef.isXLinkInverse()) {
                return new InverseXLinkMetricCounter(searcher, item.fieldDef, (XMetrics)item.xlinkContext);
            }
            if ("MIN".equals(metric.function) || "MAX".equals(metric.function) || "DISTINCT".equals(metric.function)) {
                if (item.isTransitive) {
                    return new MetricCounterTransitive.TransitiveLinkValue(filter, item.fieldDef, item.transitiveDepth, searcher);
                }
                return new MetricCounter.FieldValue(filter, item.fieldDef, searcher);
            }
            if (item.isTransitive) {
                return new MetricCounterTransitive.TransitiveLinkCount(filter, item.fieldDef, item.transitiveDepth, searcher);
            }
            return new MetricCounter.FieldCount(filter, item.fieldDef, searcher);
        }
        MetricCounter inner = MetricCounterFactory.create(searcher, metric, index + 1);
        if (item.fieldDef.isLinkField()) {
            if (item.isTransitive) {
                return new MetricCounterTransitive.TransitiveLink(filter, item.fieldDef, item.transitiveDepth, searcher, inner);
            }
            return new MetricCounter.Link(filter, item.fieldDef, searcher, inner);
        }
        if (item.fieldDef.isXLinkDirect()) {
            return new DirectXLinkMetricCounter(searcher, item.fieldDef, (XMetrics)item.xlinkContext);
        }
        if (item.fieldDef.isXLinkInverse()) {
            return new InverseXLinkMetricCounter(searcher, item.fieldDef, (XMetrics)item.xlinkContext);
        }
        throw new IllegalArgumentException("Invalid field type in metrics: " + item.fieldDef.getType().toString());
    }
}

