/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.aggregate;

import com.dell.doradus.common.FieldDefinition;
import com.dell.doradus.common.FieldType;
import com.dell.doradus.olap.aggregate.IMetricValue;
import com.dell.doradus.olap.search.Result;
import com.dell.doradus.olap.store.CubeSearcher;
import com.dell.doradus.olap.store.FieldSearcher;
import com.dell.doradus.olap.store.IntIterator;
import com.dell.doradus.olap.store.NumSearcherMV;

public abstract class MetricCounter {
    public abstract void add(int var1, IMetricValue var2);

    public static class FieldValue
    extends MetricCounter {
        private Result m_filter;
        private FieldSearcher m_fs;
        private IntIterator m_iter;

        public FieldValue(Result filter, FieldDefinition fieldDef, CubeSearcher cs) {
            this.m_filter = filter;
            this.m_fs = cs.getFieldSearcher(fieldDef.getTableName(), fieldDef.getName());
            this.m_iter = new IntIterator();
        }

        @Override
        public void add(int doc, IMetricValue value) {
            this.m_fs.fields(doc, this.m_iter);
            for (int i = 0; i < this.m_iter.count(); ++i) {
                int d = this.m_iter.get(i);
                if (this.m_filter != null && !this.m_filter.get(d)) continue;
                value.add(d);
            }
        }
    }

    public static class FieldCount
    extends MetricCounter {
        private Result m_filter;
        private FieldSearcher m_fs;
        private IntIterator m_iter;

        public FieldCount(Result filter, FieldDefinition fieldDef, CubeSearcher cs) {
            this.m_filter = filter;
            this.m_fs = cs.getFieldSearcher(fieldDef.getTableName(), fieldDef.getName());
            this.m_iter = new IntIterator();
        }

        @Override
        public void add(int doc, IMetricValue value) {
            this.m_fs.fields(doc, this.m_iter);
            int val = 0;
            if (this.m_filter == null) {
                val = this.m_iter.count();
            } else {
                for (int i = 0; i < this.m_iter.count(); ++i) {
                    int d = this.m_iter.get(i);
                    if (this.m_filter != null && !this.m_filter.get(d)) continue;
                    ++val;
                }
            }
            value.add(val);
        }
    }

    public static class NumCount
    extends MetricCounter {
        private NumSearcherMV m_ns;

        public NumCount(FieldDefinition fieldDef, CubeSearcher cs) {
            this.m_ns = cs.getNumSearcher(fieldDef.getTableName(), fieldDef.getName());
        }

        @Override
        public void add(int doc, IMetricValue value) {
            int fcount = this.m_ns.size(doc);
            value.add(fcount);
        }
    }

    public static class NumRoundup
    extends MetricCounter {
        private NumSearcherMV m_ns;
        private boolean m_bFloat = false;
        private boolean m_bDouble = false;
        private long m_roundup;

        public NumRoundup(FieldDefinition fieldDef, CubeSearcher cs, long roundup) {
            this.m_ns = cs.getNumSearcher(fieldDef.getTableName(), fieldDef.getName());
            this.m_roundup = roundup;
            this.m_bFloat = FieldType.FLOAT.equals((Object)fieldDef.getType());
            this.m_bDouble = FieldType.DOUBLE.equals((Object)fieldDef.getType());
        }

        private long roundup(long value) {
            if (this.m_bFloat) {
                float fValue = Float.intBitsToFloat((int)value);
                float remainder = fValue % (float)this.m_roundup;
                fValue -= remainder;
                if (remainder != 0.0f) {
                    fValue += (float)this.m_roundup;
                }
                return Float.floatToIntBits(fValue);
            }
            if (this.m_bDouble) {
                double dValue = Double.longBitsToDouble(value);
                double remainder = dValue % (double)this.m_roundup;
                dValue -= remainder;
                if (remainder != 0.0) {
                    dValue += (double)this.m_roundup;
                }
                return Double.doubleToLongBits(dValue);
            }
            value += this.m_roundup - 1L;
            value -= value % this.m_roundup;
            return value;
        }

        @Override
        public void add(int doc, IMetricValue value) {
            int fcount = this.m_ns.size(doc);
            for (int index = 0; index < fcount; ++index) {
                long number = this.m_ns.get(doc, index);
                number = this.roundup(number);
                value.add(number);
            }
        }
    }

    public static class Num
    extends MetricCounter {
        private NumSearcherMV m_ns;

        public Num(FieldDefinition fieldDef, CubeSearcher cs) {
            this.m_ns = cs.getNumSearcher(fieldDef.getTableName(), fieldDef.getName());
        }

        @Override
        public void add(int doc, IMetricValue value) {
            int fcount = this.m_ns.size(doc);
            for (int index = 0; index < fcount; ++index) {
                value.add(this.m_ns.get(doc, index));
            }
        }
    }

    public static class Link
    extends MetricCounter {
        private Result m_filter;
        private FieldSearcher m_fs;
        private MetricCounter m_inner;
        private IntIterator m_iter;

        public Link(Result filter, FieldDefinition fieldDef, CubeSearcher cs, MetricCounter inner) {
            this.m_filter = filter;
            this.m_fs = cs.getFieldSearcher(fieldDef.getTableName(), fieldDef.getName());
            this.m_inner = inner;
            this.m_iter = new IntIterator();
        }

        @Override
        public void add(int doc, IMetricValue value) {
            this.m_fs.fields(doc, this.m_iter);
            for (int i = 0; i < this.m_iter.count(); ++i) {
                int d = this.m_iter.get(i);
                if (this.m_filter != null && !this.m_filter.get(d)) continue;
                this.m_inner.add(d, value);
            }
        }
    }

    public static class Count
    extends MetricCounter {
        @Override
        public void add(int doc, IMetricValue value) {
            value.add(1L);
        }
    }

    public static class FilteredCounter
    extends MetricCounter {
        private Result m_filter;
        private MetricCounter m_inner;

        public FilteredCounter(Result filter, MetricCounter inner) {
            this.m_filter = filter;
            this.m_inner = inner;
        }

        @Override
        public void add(int doc, IMetricValue value) {
            if (doc < 0 || this.m_filter.get(doc)) {
                this.m_inner.add(doc, value);
            }
        }
    }
}

