/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.aggregate;

import com.dell.doradus.common.TableDefinition;
import com.dell.doradus.olap.io.BSTR;
import com.dell.doradus.olap.io.FileDeletedException;
import com.dell.doradus.olap.merge.RestorableIxDoc;
import com.dell.doradus.search.FieldSet;
import com.dell.doradus.search.SearchResult;
import com.dell.doradus.search.SearchResultList;
import com.dell.doradus.search.util.HeapList;
import com.dell.doradus.utilities.Timer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuplicationDetection {
    private static Logger LOG = LoggerFactory.getLogger((String)"DuplicationDetection");

    public static SearchResultList getDuplicateIDs(TableDefinition tableDef, List<String> shards) {
        for (int i = 0; i < 5; ++i) {
            try {
                return DuplicationDetection.getDuplicateIDsInternal(tableDef, shards);
            }
            catch (FileDeletedException ex) {
                LOG.warn(ex.getMessage() + " - retrying: " + i);
                continue;
            }
        }
        throw new FileDeletedException("All retries to getDuplicateIDs failed");
    }

    public static SearchResultList getDuplicateIDsInternal(TableDefinition tableDef, List<String> shards) {
        Timer timer = new Timer();
        LOG.debug("Find duplicate ids in {}/{}", (Object)tableDef.getAppDef().getAppName(), (Object)tableDef.getTableName());
        int documentsCount = 0;
        HashMap result = new HashMap();
        ArrayList<String> curShards = new ArrayList<String>();
        BSTR last_id = new BSTR();
        last_id.length = -1;
        HeapList<RestorableIxDoc> heap = new HeapList<RestorableIxDoc>(shards.size() - 1);
        RestorableIxDoc current = null;
        for (int i = 0; i < shards.size(); ++i) {
            current = new RestorableIxDoc(i, tableDef, shards.get(i));
            current.next();
            current = heap.AddEx(current);
        }
        while (current != null && current.id != null) {
            ++documentsCount;
            if (!BSTR.isEqual(last_id, current.id)) {
                if (curShards.size() > 1) {
                    result.put(last_id.toString(), new ArrayList(curShards));
                }
                last_id.set(current.id);
                curShards.clear();
            }
            curShards.add(shards.get(current.segment));
            current.next();
            current = heap.AddEx(current);
        }
        if (curShards.size() > 1) {
            result.put(last_id.toString(), new ArrayList(curShards));
        }
        SearchResultList res = new SearchResultList();
        FieldSet fs = new FieldSet(tableDef);
        res.documentsCount = documentsCount;
        StringBuilder sb = new StringBuilder();
        for (Map.Entry elem : result.entrySet()) {
            SearchResult r = new SearchResult();
            r.fieldSet = fs;
            r.scalars.put("_ID", (String)elem.getKey());
            sb.setLength(0);
            for (String shard : (List)elem.getValue()) {
                sb.append(shard);
                sb.append(',');
            }
            sb.setLength(sb.length() - 1);
            r.scalars.put("shards", sb.toString());
            res.results.add(r);
        }
        LOG.debug("Found {} duplicate ids {}/{} merged in {}", new Object[]{result.size(), tableDef.getAppDef().getAppName(), tableDef.getTableName(), timer});
        return res;
    }
}

