/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.aggregate;

import com.dell.doradus.common.UNode;
import com.dell.doradus.olap.aggregate.AggregationRequest;
import com.dell.doradus.olap.aggregate.MetricValueSet;
import com.dell.doradus.search.util.HeapSort;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class AggregationResult {
    public int documentsCount;
    public int groupsCount;
    public AggregationGroup summary;
    public List<AggregationGroup> groups = new ArrayList<AggregationGroup>();

    public UNode toUNode() {
        UNode groupsNode;
        UNode result = UNode.createMapNode((String)"results");
        result.addValueNode("documentsCount", "" + this.documentsCount, true);
        result.addValueNode("groupsCount", "" + this.groupsCount, true);
        if (this.summary != null) {
            groupsNode = result.addArrayNode("summary");
            groupsNode.addChildNode(this.summary.toUNode());
        }
        groupsNode = result.addArrayNode("groups");
        for (AggregationGroup group : this.groups) {
            groupsNode.addChildNode(group.toUNode());
        }
        return result;
    }

    public String toString() {
        String str = this.toUNode().toXML(true);
        if (str.length() > 10000) {
            str = String.valueOf(str.substring(0, 10000)) + "...";
        }
        return str;
    }

    public static AggregationResult merge(AggregationResult[] results, int top) {
        AggregationResult result = new AggregationResult();
        HeapSort<AggregationGroup> sorter = new HeapSort<AggregationGroup>();
        AggregationResult[] aggregationResultArray = results;
        int n = results.length;
        int n2 = 0;
        while (n2 < n) {
            AggregationResult r = aggregationResultArray[n2];
            result.documentsCount += r.documentsCount;
            Collections.sort(r.groups);
            sorter.add(r.groups);
            if (result.summary == null) {
                result.summary = r.summary;
            } else if (r.summary != null) {
                result.summary.merge(r.summary);
            }
            ++n2;
        }
        AggregationGroup current = null;
        for (AggregationGroup group : sorter) {
            if (current == null) {
                current = group;
                continue;
            }
            if (current.compareTo(group) == 0) {
                current.merge(group);
                continue;
            }
            result.groups.add(current);
            current = group;
        }
        if (current != null) {
            result.groups.add(current);
        }
        result.groupsCount = result.groups.size();
        AggregationResult.applyLimit(result, top);
        return result;
    }

    public static void applyLimits(AggregationResult result, AggregationRequest request, int level) {
        if (result == null) {
            return;
        }
        AggregationResult.applyLimit(result, request.getTop(level));
        for (AggregationGroup group : result.groups) {
            AggregationResult.applyLimits(group.innerResult, request, level + 1);
        }
    }

    private static void applyLimit(AggregationResult result, int top) {
        if (top > 0) {
            Collections.sort(result.groups, new Comparator<AggregationGroup>(){

                @Override
                public int compare(AggregationGroup x, AggregationGroup y) {
                    return y.metricSet.compareTo(x.metricSet);
                }
            });
            if (result.groups.size() > top) {
                result.groups = result.groups.subList(0, top);
            }
        } else if (top < 0) {
            Collections.sort(result.groups, new Comparator<AggregationGroup>(){

                @Override
                public int compare(AggregationGroup x, AggregationGroup y) {
                    return x.metricSet.compareTo(y.metricSet);
                }
            });
            if (result.groups.size() > -top) {
                result.groups = result.groups.subList(0, -top);
            }
        }
    }

    public static class AggregationGroup
    implements Comparable<AggregationGroup> {
        public Object id;
        public String name;
        public MetricValueSet metricSet;
        public AggregationResult innerResult;

        public void merge(AggregationGroup other) {
            this.metricSet.add(other.metricSet);
            if (this.innerResult == null) {
                if (other.innerResult != null) {
                    this.innerResult = other.innerResult;
                }
            } else if (other.innerResult != null) {
                AggregationResult[] rs = new AggregationResult[]{this.innerResult, other.innerResult};
                this.innerResult = AggregationResult.merge(rs, 0);
            }
        }

        public long getCount() {
            String val = this.metricSet.values[0].toString();
            if (val == null) {
                return 0L;
            }
            try {
                return Long.parseLong(val);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
        }

        @Override
        public int compareTo(AggregationGroup other) {
            if (this.id == null && other.id == null) {
                return 0;
            }
            if (this.id == null) {
                return -1;
            }
            if (other.id == null) {
                return 1;
            }
            return ((Comparable)this.id).compareTo(other.id);
        }

        public boolean equals(Object obj) {
            AggregationGroup other = (AggregationGroup)obj;
            if (this.id == null && other.id == null) {
                return true;
            }
            if (this.id == null) {
                return false;
            }
            if (other.id == null) {
                return false;
            }
            return this.id.equals(other.id);
        }

        public int hashCode() {
            if (this.id == null) {
                return 0;
            }
            return this.id.hashCode();
        }

        public UNode toUNode() {
            UNode result = UNode.createMapNode((String)"group");
            if (this.name != null) {
                result.addValueNode("name", this.name, true);
            }
            int i = 0;
            while (i < this.metricSet.values.length) {
                String value = this.metricSet.values[i].toString();
                if (value == null) {
                    value = "";
                }
                result.addValueNode("metric_" + i, value, true);
                ++i;
            }
            if (this.innerResult != null) {
                result.addChildNode(this.innerResult.toUNode());
            }
            return result;
        }

        public String toString() {
            return this.toUNode().toXML();
        }
    }
}

