/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.aggregate;

import com.dell.doradus.common.ApplicationDefinition;
import com.dell.doradus.common.TableDefinition;
import com.dell.doradus.common.Utils;
import com.dell.doradus.olap.Olap;
import com.dell.doradus.olap.aggregate.AggregationRequestData;
import com.dell.doradus.olap.xlink.XLinkContext;
import com.dell.doradus.olap.xlink.XLinkGroupContext;
import com.dell.doradus.olap.xlink.XLinkMetricContext;
import com.dell.doradus.search.aggregate.AggregationGroup;
import com.dell.doradus.search.aggregate.AggregationMetric;
import com.dell.doradus.search.aggregate.MetricExpression;
import com.dell.doradus.search.parser.AggregationQueryBuilder;
import com.dell.doradus.search.parser.DoradusQueryBuilder;
import com.dell.doradus.search.query.Query;
import java.util.ArrayList;
import java.util.List;

public class AggregationRequest {
    public Olap olap;
    public String application;
    public ApplicationDefinition appDef;
    public TableDefinition tableDef;
    public List<String> shards;
    public List<String> xshards;
    public Part[] parts;
    public boolean flat;
    public boolean differentMetricsForPairs;

    public AggregationRequest(Olap olap, ApplicationDefinition appDef, AggregationRequestData requestData) {
        this.olap = olap;
        this.application = requestData.application;
        this.tableDef = appDef.getTableDef(requestData.table);
        Utils.require((this.tableDef != null ? 1 : 0) != 0, (String)("Table " + requestData.table + " not found"));
        this.shards = requestData.shards;
        this.xshards = requestData.xshards;
        this.flat = requestData.flat;
        this.differentMetricsForPairs = requestData.differentMetricsForPairs;
        this.parts = new Part[requestData.parts.length];
        int i = 0;
        while (i < this.parts.length) {
            this.parts[i] = new Part();
            this.parts[i].query = DoradusQueryBuilder.Build(requestData.parts[i].query, this.tableDef);
            if (requestData.parts[i].field != null) {
                ArrayList<ArrayList<AggregationGroup>> groupsSet = AggregationGroup.GetAggregationList(requestData.parts[i].field, this.tableDef);
                Utils.require((groupsSet.size() == 1 ? 1 : 0) != 0, (String)"Olap does not support multiple group sets");
                this.parts[i].groups = groupsSet.get(0);
            } else {
                this.parts[i].groups = new ArrayList<AggregationGroup>(0);
            }
            this.parts[i].metrics = AggregationQueryBuilder.BuildAggregationMetricsExpression(requestData.parts[i].metrics, this.tableDef);
            ++i;
        }
        XLinkContext xcontext = new XLinkContext(requestData.application, olap, this.xshards, this.tableDef);
        XLinkGroupContext xgroupContext = new XLinkGroupContext(xcontext);
        XLinkMetricContext xmetriccontext = new XLinkMetricContext(xcontext);
        int i2 = 0;
        while (i2 < this.parts.length) {
            xcontext.setupXLinkQuery(this.tableDef, this.parts[i2].query);
            for (AggregationGroup group : this.parts[i2].groups) {
                xgroupContext.setupXLinkGroup(group);
            }
            xmetriccontext.setupXLinkMetric(this.parts[i2].metrics);
            ++i2;
        }
    }

    public boolean isOnlyCountStar() {
        if (this.parts.length > 1) {
            return false;
        }
        if (this.parts[0].metrics.size() != 1) {
            return false;
        }
        MetricExpression me = this.parts[0].metrics.get(0);
        if (!(me instanceof AggregationMetric)) {
            return false;
        }
        AggregationMetric am = (AggregationMetric)me;
        if (!"COUNT".equals(am.function)) {
            return false;
        }
        if (am.items != null && am.items.size() != 0) {
            return false;
        }
        if (am.filter != null) {
            return false;
        }
        Part[] partArray = this.parts;
        int n = this.parts.length;
        int n2 = 0;
        while (n2 < n) {
            Part part = partArray[n2];
            if (part.groups != null && part.groups.size() != 0) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public int getTop(int group) {
        if (this.parts[0].groups == null || this.parts[0].groups.size() <= group) {
            return 0;
        }
        int top = this.parts[0].groups.get((int)group).selectionValue;
        if (this.parts[0].groups.get((int)0).selection == AggregationGroup.Selection.Bottom) {
            top = -top;
        }
        return top;
    }

    public static class Part {
        public Query query;
        public List<AggregationGroup> groups;
        public List<MetricExpression> metrics;

        public AggregationGroup getSingleGroup() {
            if (this.groups == null || this.groups.size() == 0) {
                return null;
            }
            Utils.require((this.groups.size() == 1 ? 1 : 0) != 0, (String)"More than one group present");
            return this.groups.get(0);
        }
    }
}

