/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.olap.aggregate;

import com.dell.doradus.common.AggregateResult;
import com.dell.doradus.common.Utils;
import com.dell.doradus.olap.OlapAggregate;
import com.dell.doradus.olap.aggregate.AggregationResult;
import java.util.ArrayList;
import java.util.List;

public class AggregateResultConverter {
    public static AggregateResult create(AggregationResult result, OlapAggregate aggregate) {
        AggregateResult aggResult = new AggregateResult();
        aggResult.setMetricParam(aggregate.getMetrics());
        aggResult.setQueryParam(aggregate.getQuery());
        aggResult.setGroupingParam(aggregate.getFields());
        aggResult.setTotalObjects((long)result.documentsCount);
        if (result.summary == null) {
            aggResult.setGlobalValue(Integer.toString(result.documentsCount));
            return aggResult;
        }
        int metricsCount = result.summary.metricSet.values.length;
        List<String> metricValues = AggregateResultConverter.parseMetrics(aggregate.getMetrics());
        Utils.require((metricValues.size() == metricsCount ? 1 : 0) != 0, (String)"Unexpected metrics count");
        if (metricsCount == 1 && aggregate.getFields() == null) {
            aggResult.setGlobalValue(result.summary.metricSet.values[0].toString());
            return aggResult;
        }
        List<String> groupNames = AggregateResultConverter.parseAggregationGroups(aggregate.getFields());
        int i = 0;
        while (i < metricsCount) {
            AggregateResult.AggGroupSet groupSet = aggResult.addGroupSet();
            groupSet.setGroupingParam(aggregate.getFields());
            groupSet.setMetricParam(metricValues.get(i).trim());
            groupSet.setGroupsetValue(result.summary.metricSet.values[i].toString());
            if (groupNames.size() != 0) {
                groupSet.setTotalGroups((long)result.groupsCount);
                for (AggregationResult.AggregationGroup group : result.groups) {
                    AggregateResult.AggGroup grp = groupSet.addGroup();
                    grp.setComposite(false);
                    grp.setFieldName(groupNames.get(0));
                    grp.setFieldValue(group.name == null ? "(null)" : group.name);
                    grp.setGroupValue(group.metricSet.values[i].toString());
                    if (group.innerResult == null) continue;
                    AggregateResultConverter.addNested(group.innerResult, groupNames, 1, grp, i);
                }
            }
            ++i;
        }
        return aggResult;
    }

    private static List<String> parseMetrics(String metrics) {
        List<String> metricValues = AggregateResultConverter.splitOuter(metrics, ',');
        int i = 0;
        while (i < metricValues.size()) {
            String mv = metricValues.get(i);
            int asIndex = mv.lastIndexOf("AS");
            if (asIndex >= 0) {
                mv = mv.substring(asIndex + 2).trim();
                metricValues.set(i, mv);
            }
            ++i;
        }
        return metricValues;
    }

    private static List<String> splitOuter(String str, char sepChr) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder buffer = new StringBuilder();
        int nesting = 0;
        boolean bInQuote = false;
        int index = 0;
        while (index < str.length()) {
            char ch = str.charAt(index);
            switch (ch) {
                case '(': {
                    buffer.append(ch);
                    ++nesting;
                    break;
                }
                case ')': {
                    buffer.append(ch);
                    --nesting;
                    break;
                }
                case '\"': 
                case '\'': {
                    buffer.append(ch);
                    nesting = bInQuote ? --nesting : ++nesting;
                    bInQuote = !bInQuote;
                    break;
                }
                case ',': {
                    if (nesting == 0) {
                        result.add(buffer.toString());
                        buffer.setLength(0);
                        break;
                    }
                    buffer.append(ch);
                    break;
                }
                default: {
                    buffer.append(ch);
                }
            }
            ++index;
        }
        if (buffer.length() > 0) {
            result.add(buffer.toString());
        }
        return result;
    }

    private static void addNested(AggregationResult res, List<String> groupNames, int aggGroupIndex, AggregateResult.AggGroup parent, int metricsIndex) {
        String groupName = groupNames.get(aggGroupIndex);
        for (AggregationResult.AggregationGroup group : res.groups) {
            AggregateResult.AggGroup grp = parent.addGroup();
            grp.setComposite(false);
            grp.setFieldName(groupName);
            grp.setFieldValue(group.name == null ? "(null)" : group.name);
            grp.setGroupValue(group.metricSet.values[metricsIndex].toString());
            if (group.innerResult == null) continue;
            AggregateResultConverter.addNested(group.innerResult, groupNames, aggGroupIndex + 1, grp, metricsIndex);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static List<String> parseAggregationGroups(String groups) {
        result = new ArrayList<String>();
        if (groups != null) ** GOTO lbl15
        return result;
lbl-1000:
        // 1 sources

        {
            index = AggregateResultConverter.scanForComma(groups);
            if (index < 0) {
                name = AggregateResultConverter.extractGroupName(groups);
                result.add(name);
                break;
            }
            name = groups.substring(0, index);
            groups = groups.substring(index + 1);
            name = AggregateResultConverter.extractGroupName(name);
            result.add(name);
lbl15:
            // 2 sources

            ** while (groups.length() > 0)
        }
lbl16:
        // 2 sources

        return result;
    }

    private static String extractGroupName(String name) {
        int idx = name.lastIndexOf(" AS ");
        int lastClosingBracket = name.lastIndexOf(41);
        if (idx >= 0 && (lastClosingBracket < 0 || lastClosingBracket < idx)) {
            name = name.substring(idx + 4);
        } else {
            idx = name.indexOf(".AS(");
            if (idx >= 0) {
                name = name.substring(idx + 4);
                name = name.substring(0, name.length() - 1);
            } else if (name.startsWith("TOP") || name.startsWith("BOTTOM")) {
                name = name.substring(name.indexOf(44) + 1, name.lastIndexOf(41));
            }
        }
        return name.trim();
    }

    private static int scanForComma(String groups) {
        int nestedLevel = 0;
        boolean doubleQuotes = false;
        boolean singleQuotes = false;
        int index = -1;
        while ((index = AggregateResultConverter.indexOfAny(groups, index + 1, '(', ')', ',', '\'', '\"')) >= 0) {
            switch (groups.charAt(index)) {
                case '(': {
                    if (doubleQuotes || singleQuotes) break;
                    ++nestedLevel;
                    break;
                }
                case ')': {
                    if (!doubleQuotes && !singleQuotes) {
                        --nestedLevel;
                    }
                    if (nestedLevel >= 0) break;
                    throw new RuntimeException("Error parsing groups");
                }
                case ',': {
                    if (nestedLevel != 0 || doubleQuotes || singleQuotes) break;
                    return index;
                }
                case '\'': {
                    if (doubleQuotes) break;
                    singleQuotes = !singleQuotes;
                    break;
                }
                case '\"': {
                    if (singleQuotes) break;
                    doubleQuotes = !doubleQuotes;
                }
            }
        }
        return -1;
    }

    private static int indexOfAny(String str, int fromIndex, char ... chars) {
        int index = -1;
        int i = 0;
        while (i < chars.length) {
            int newindex = str.indexOf(chars[i], fromIndex);
            if (index < 0 || newindex >= 0 && newindex < index) {
                index = newindex;
            }
            ++i;
        }
        return index;
    }
}

